package Gantry::GENSamples;

use strict;

use Gantry qw{ -TemplateEngine=TT };

our @ISA = qw( Gantry );

use Gantry::Samples::FileUpload;
use Gantry::Samples::AjaxRequest;

##-----------------------------------------------------------------
## $self->init( $r )
##-----------------------------------------------------------------
#sub init {
#    my ( $self, $r ) = @_;
#
#    # process SUPER's init code
#    $self->SUPER::init( $r );
#
#} # END init


#-----------------------------------------------------------------
# $self->do_main( )
#-----------------------------------------------------------------
sub do_main {
    my ( $self ) = shift;

    $self->stash->view->template( 'main.tt' );
    $self->stash->view->title( 'Samples' );

    $self->stash->view->data( {
        pages => [
            { link => 'fileupload', label => 'File Upload' },
            { link => 'ajaxrequest', label => 'Ajax Request' },
        ],
    } );
}

#-----------------------------------------------------------------
# $self->site_links( )
#-----------------------------------------------------------------
sub site_links {
    my $self = shift;

    return [
        { link => $self->app_rootp() . 'fileupload', label => 'File Upload' },
        { link => $self->app_rootp() . 'ajaxrequest', label => 'Ajax Request' },
    ];
}

1;

=head1 NAME

Gantry::GENSamples - generated support module for Gantry::Samples

=head1 SYNOPSIS

In Gantry::Samples:

    use base 'Gantry::GENSamples';

=head1 DESCRIPTION

This module was generated by Bigtop (and IS subject to regeneration) to
provide methods in support of the whole Gantry::Samples
application.

Gantry::Samples should inherit from this module.

=head1 METHODS

=over 4

=item init

=item do_main

=item site_links


=back

=head1 AUTHOR

Phil Crow, E<lt>pcrow@localdomainE<gt>

=head1 COPYRIGHT AND LICENSE

Copyright (C) 2006 Phil Crow

This library is free software; you can redistribute it and/or modify
it under the same terms as Perl itself, either Perl version 5.8.6 or,
at your option, any later version of Perl 5 you may have available.

=cut
