/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.tiny.CompressedWhitespace;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.SchemaType;

public class CommentStripper
extends ProxyReceiver {
    private CompressedWhitespace savedWhitespace = null;
    private FastStringBuffer buffer = new FastStringBuffer(256);

    public CommentStripper(Receiver next) {
        super(next);
    }

    public void startElement(NodeName nameCode, SchemaType typeCode, int locationId, int properties) throws XPathException {
        this.flush();
        this.nextReceiver.startElement(nameCode, typeCode, locationId, properties);
    }

    public void endElement() throws XPathException {
        this.flush();
        this.nextReceiver.endElement();
    }

    public void characters(CharSequence chars, int locationId, int properties) throws XPathException {
        if (chars instanceof CompressedWhitespace) {
            if (this.buffer.length() == 0 && this.savedWhitespace == null) {
                this.savedWhitespace = (CompressedWhitespace)chars;
            } else {
                ((CompressedWhitespace)chars).uncompress(this.buffer);
            }
        } else {
            if (this.savedWhitespace != null) {
                this.savedWhitespace.uncompress(this.buffer);
                this.savedWhitespace = null;
            }
            this.buffer.append(chars);
        }
    }

    public void comment(CharSequence chars, int locationId, int properties) {
    }

    public void processingInstruction(String name, CharSequence data, int locationId, int properties) {
    }

    private void flush() throws XPathException {
        if (this.buffer.length() > 0) {
            this.nextReceiver.characters(this.buffer, 0, 0);
        } else if (this.savedWhitespace != null) {
            this.nextReceiver.characters(this.savedWhitespace, 0, 0);
        }
        this.savedWhitespace = null;
        this.buffer.setLength(0);
    }
}

