#!/usr/bin/perl

package eBay::API::XML::Call::RespondToFeedback;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. RespondToFeedback.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::RespondToFeedback

=head1 DESCRIPTION



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::RespondToFeedback inherits from the L<eBay::API::XML::BaseCall> class

=cut

use eBay::API::XML::BaseCall;
our @ISA = ("eBay::API::XML::BaseCall");

use eBay::API::XML::Call::RespondToFeedback::RespondToFeedbackRequestType;
use eBay::API::XML::Call::RespondToFeedback::RespondToFeedbackResponseType;


=head1 Subroutines:

=cut

sub getApiCallName {
   return 'RespondToFeedback';
}
sub getRequestDataTypeFullPackage {
   return 'eBay::API::XML::Call::RespondToFeedback::RespondToFeedbackRequestType';
}
sub getResponseDataTypeFullPackage {
   return 'eBay::API::XML::Call::RespondToFeedback::RespondToFeedbackResponseType';
}

#
# input properties
#

=head2 setFeedbackID()

ID that uniquely identifies the feedback.
FeedbackIDs can be retrieved by using
GetFeedback. Required if ItemID is not
specified.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut
       
sub setFeedbackID {
   my $self   = shift;
   my $sFeedbackID = shift;
   $self->getRequestDataType()->setFeedbackID($sFeedbackID);
}

=head2 setItemID()

Unique identifier of an item to which the
feedback is attached. Required if FeedbackID is
not provided.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Conditionally
#    Argument: 'ns:ItemIDType'

=cut
       
sub setItemID {
   my $self   = shift;
   my $pItemID = shift;
   $self->getRequestDataType()->setItemID($pItemID);
}

=head2 setResponseText()

Textual comment that the user who is
subject of feedback may leave in response or
rebuttal to the feedback. Alternatively, when
the  ResponseType is FollowUp, this value
contains the text of the follow-up comment. Max
length is 125 for the Taiwan site.

MaxLength: 80

  RequiredInput: Yes
#    Argument: 'xs:string'

=cut
       
sub setResponseText {
   my $self   = shift;
   my $sResponseText = shift;
   $self->getRequestDataType()->setResponseText($sResponseText);
}

=head2 setResponseType()

Specifies whether the response is a reply
or a follow-up.

  RequiredInput: Yes
#    Argument: 'ns:FeedbackResponseCodeType'

=cut
       
sub setResponseType {
   my $self   = shift;
   my $sResponseType = shift;
   $self->getRequestDataType()->setResponseType($sResponseType);
}

=head2 setTargetUserID()

User who left the feedback that is being
replied to or followed up on.

  RequiredInput: Yes
#    Argument: 'ns:UserIDType'

=cut
       
sub setTargetUserID {
   my $self   = shift;
   my $pTargetUserID = shift;
   $self->getRequestDataType()->setTargetUserID($pTargetUserID);
}

=head2 setTransactionID()

Unique identifier for a purchase from an
eBay Stores Inventory or basic fixed price
listing. If TransactionID is specified, ItemID
must also be specified.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: No
#    Argument: 'xs:string'

=cut
       
sub setTransactionID {
   my $self   = shift;
   my $sTransactionID = shift;
   $self->getRequestDataType()->setTransactionID($sTransactionID);
}



#
# output properties
#





1;   
