/**
 * pdfXtk-Extras - PDF Extraction Toolkit Extras
 * Copyright (c) by the authors/contributors.  All rights reserved.
 * This project includes code from PDFBox and TouchGraph.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *
 * 1. Redistributions of source code must retain the above copyright notice,
 *    this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright notice,
 *    this list of conditions and the following disclaimer in the documentation
 *    and/or other materials provided with the distribution.
 * 3. Neither the names pdfXtk or PDF Extraction Toolkit; nor the names of its
 *    contributors may be used to endorse or promote products derived from this
 *    software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
 * ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * http://pdfxtk.sourceforge.net
 *
 */
package at.ac.tuwien.dbai.pdfwrap.table;

import java.util.Iterator;
import java.util.List;

import org.w3c.dom.Document;
import org.w3c.dom.Element;

import at.ac.tuwien.dbai.pdfwrap.model.document.CompositeSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.GenericSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.IXHTMLSegment;
import at.ac.tuwien.dbai.pdfwrap.model.document.TextSegment;


/**
 * Table document element
 * 
 * @author Tamir Hassan, pdfanalyser@tamirhassan.com
 * @version PDF Analyser 0.9
 */
public class OrderedTable extends CompositeSegment<TableRow> implements IXHTMLSegment
{
//	List<CompositeSegment> items;
   
    public OrderedTable(
        float x1,
        float x2,
        float y1,
        float y2
        )
    {
		super(x1, x2, y1, y2);
    }
    
    public OrderedTable(
        float x1,
        float x2,
        float y1,
        float y2,
		List<TableRow> items
        )
    {
//		super(x1, x2, y1, y2, items);
    	super(x1, x2, y1, y2);
    	this.items = items;
    }
    
    public OrderedTable(List<TableRow> items)
    {
//      super(items);
    	super();
    	this.items = items;
    }
    
    public OrderedTable(
            )
    {
        super();
    }
    
    public void addAsXHTML(Document resultDocument, Element parent)//, GenericSegment pageDim)
    {
        Element newTableElement = resultDocument.createElement("table");
        
        for (TableRow thisRow : items)
        {
            
            Element newRowElement = resultDocument.createElement("tr");
            
            for (TableCell thisCell : thisRow.getItems())
            {
                Element newColumnElement = resultDocument.createElement("td");
                
                //System.out.println("in colIter with: " + thisCell);
                
                if (thisCell.getColspan() > 1) {
                	newColumnElement.setAttribute
                    ("colspan", Integer.toString(thisCell.getColspan()));
                }
                
                if (thisCell.getRowspan() > 1) {
                	newColumnElement.setAttribute
                    ("rowspan", Integer.toString(thisCell.getRowspan()));
                }
                
                // this bit added 22.11.06
                // to replace every occurrence of "\n" in the string
                // with a <br/> tag.
                
                // TODO: refactor and move to e.g. Utils method
                // so that it can be used for other segments/elements
                // containing text.
                
                String theText = thisCell.getText();
                // the following lines would just add the string
                // without <br/>s
                //newColumnElement.appendChild
    			//(resultDocument.createTextNode(theText));
                String textSection = new String();
                
                for (int n = 0; n < theText.length(); n ++)
                {
                	String thisChar = theText.substring(n, n + 1);
                	if (thisChar.equals("\n"))
                	{
                		newColumnElement.appendChild
                			(resultDocument.createTextNode(textSection));
                        newColumnElement.appendChild
                        	(resultDocument.createElement("br"));
                        textSection = "";
                	}
                	else
                	{
                		textSection = textSection.concat(thisChar);
                	}
                }
                
                if (textSection.length() > 0)
                	newColumnElement.appendChild
        			(resultDocument.createTextNode(textSection));
                
                newRowElement.appendChild(newColumnElement);
            }
            newTableElement.appendChild(newRowElement);
        }
        
        parent.appendChild(newTableElement);
    }
 
    
    public void addAsXmillum(Document resultDocument, Element parent, 
    		GenericSegment pageDim, float resolution)
    {
        // first add the whole table object
    	Element newSegmentElement = resultDocument.createElement(tagName());
    	this.setElementAttributes(resultDocument, newSegmentElement, pageDim, resolution);
    	parent.appendChild(newSegmentElement);
    	
    	// then add the individual cells
        Iterator rowIter = items.iterator();
        while(rowIter.hasNext())
        {
        	Object o = rowIter.next();
        	if (o instanceof CompositeSegment)
        	{
	            //CompoundTextSegment thisRow =
	            //    (CompoundTextSegment)rowIter.next();
        		CompositeSegment thisRow =
	                (CompositeSegment)o;
	            Iterator colIter = thisRow.getItems().iterator();
	            
	            while(colIter.hasNext())
	            {   
	                TableCell thisCell = 
	                    (TableCell)colIter.next();
	                thisCell.addAsXmillum(resultDocument, parent, pageDim, resolution);
	                
	            }
        	}
        }
    }
    

    public String toCSV()  //TODO: add span support
    {
        StringBuffer retVal = new StringBuffer();
        Iterator rowIter = items.iterator();
        while(rowIter.hasNext())
        {
            CompositeSegment thisRow =
                (CompositeSegment)rowIter.next();
            Iterator colIter = thisRow.getItems().iterator();
            while(colIter.hasNext())
            {
                // TODO: think about a TableCell object?
                TextSegment thisCell = 
                    (TextSegment)colIter.next();
                if (colIter.hasNext())
                    retVal.append("\"" + thisCell.getText() + "\",");
                else
                    retVal.append("\"" + thisCell.getText() + "\"\n");
            }
        }
        return retVal.toString();
    }
    
    public String toString()
    {
        // TODO: improve presentation
        StringBuffer retVal = new StringBuffer();
        retVal.append("\n****Table: - " + super.getAttributes() + "\n");
        Iterator rowIter = items.iterator();
        while(rowIter.hasNext())
        {
        	Object o = rowIter.next();
        	if (o instanceof CompositeSegment)
        	{
        		// 30.11.06  TODO: separate variable for
        		// rows and other objects within table
        		// (e.g. ruling lines).
	            //CompoundTextSegment thisRow =
	            //    (CompoundTextSegment)rowIter.next();
        		CompositeSegment thisRow = 
        			(CompositeSegment)o;
        		retVal.append(thisRow.getItems().size() + "/ ");
	            Iterator colIter = thisRow.getItems().iterator();
	            while(colIter.hasNext())
	            {
	                // TODO: think about a TableCell object?
	                TextSegment thisCell = 
	                    (TextSegment)colIter.next();
	                if (colIter.hasNext())
	                    retVal.append(thisCell.getText() + " | ");
	                else
	                    retVal.append(thisCell.getText() + "\n");
	            }
        	}
        }
        return retVal.toString();
    }

    
    public void findBoundingBox()
    {
    	for(CompositeSegment<TableCell> row : items)
    	{
    		row.findBoundingBox();
//    		Iterator<TableCell> iter2 = row.getItems().iterator();
//    		while(iter2.hasNext())
//    		{
//    			TableCell cell = iter2.next();
//    			cell.findBoundingBox();
//    		}
    	}
    	super.findBoundingBox();
    }
}
