# Generated by default/object.tt
package Paws::CloudFront::Origin;
  use Moose;
  has ConnectionAttempts => (is => 'ro', isa => 'Int');
  has ConnectionTimeout => (is => 'ro', isa => 'Int');
  has CustomHeaders => (is => 'ro', isa => 'Paws::CloudFront::CustomHeaders');
  has CustomOriginConfig => (is => 'ro', isa => 'Paws::CloudFront::CustomOriginConfig');
  has DomainName => (is => 'ro', isa => 'Str', required => 1);
  has Id => (is => 'ro', isa => 'Str', required => 1);
  has OriginPath => (is => 'ro', isa => 'Str');
  has OriginShield => (is => 'ro', isa => 'Paws::CloudFront::OriginShield');
  has S3OriginConfig => (is => 'ro', isa => 'Paws::CloudFront::S3OriginConfig');

1;

### main pod documentation begin ###

=head1 NAME

Paws::CloudFront::Origin

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::CloudFront::Origin object:

  $service_obj->Method(Att1 => { ConnectionAttempts => $value, ..., S3OriginConfig => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::CloudFront::Origin object:

  $result = $service_obj->Method(...);
  $result->Att1->ConnectionAttempts

=head1 DESCRIPTION

An origin.

An origin is the location where content is stored, and from which
CloudFront gets content to serve to viewers. To specify an origin:

=over

=item *

Use C<S3OriginConfig> to specify an Amazon S3 bucket that is not
configured with static website hosting.

=item *

Use C<CustomOriginConfig> to specify all other kinds of origins,
including:

=over

=item *

An Amazon S3 bucket that is configured with static website hosting

=item *

An Elastic Load Balancing load balancer

=item *

An AWS Elemental MediaPackage endpoint

=item *

An AWS Elemental MediaStore container

=item *

Any other HTTP server, running on an Amazon EC2 instance or any other
kind of host

=back

=back

For the current maximum number of origins that you can specify per
distribution, see General Quotas on Web Distributions
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/cloudfront-limits.html#limits-web-distributions)
in the I<Amazon CloudFront Developer Guide> (quotas were formerly
referred to as limits).

=head1 ATTRIBUTES


=head2 ConnectionAttempts => Int

The number of times that CloudFront attempts to connect to the origin.
The minimum number is 1, the maximum is 3, and the default (if you
donE<rsquo>t specify otherwise) is 3.

For a custom origin (including an Amazon S3 bucket thatE<rsquo>s
configured with static website hosting), this value also specifies the
number of times that CloudFront attempts to get a response from the
origin, in the case of an Origin Response Timeout
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginResponseTimeout).

For more information, see Origin Connection Attempts
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-attempts)
in the I<Amazon CloudFront Developer Guide>.


=head2 ConnectionTimeout => Int

The number of seconds that CloudFront waits when trying to establish a
connection to the origin. The minimum timeout is 1 second, the maximum
is 10 seconds, and the default (if you donE<rsquo>t specify otherwise)
is 10 seconds.

For more information, see Origin Connection Timeout
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#origin-connection-timeout)
in the I<Amazon CloudFront Developer Guide>.


=head2 CustomHeaders => L<Paws::CloudFront::CustomHeaders>

A list of HTTP header names and values that CloudFront adds to the
requests that it sends to the origin.

For more information, see Adding Custom Headers to Origin Requests
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/add-origin-custom-headers.html)
in the I<Amazon CloudFront Developer Guide>.


=head2 CustomOriginConfig => L<Paws::CloudFront::CustomOriginConfig>

Use this type to specify an origin that is not an Amazon S3 bucket,
with one exception. If the Amazon S3 bucket is configured with static
website hosting, use this type. If the Amazon S3 bucket is not
configured with static website hosting, use the C<S3OriginConfig> type
instead.


=head2 B<REQUIRED> DomainName => Str

The domain name for the origin.

For more information, see Origin Domain Name
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesDomainName)
in the I<Amazon CloudFront Developer Guide>.


=head2 B<REQUIRED> Id => Str

A unique identifier for the origin. This value must be unique within
the distribution.

Use this value to specify the C<TargetOriginId> in a C<CacheBehavior>
or C<DefaultCacheBehavior>.


=head2 OriginPath => Str

An optional path that CloudFront appends to the origin domain name when
CloudFront requests content from the origin.

For more information, see Origin Path
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-web-values-specify.html#DownloadDistValuesOriginPath)
in the I<Amazon CloudFront Developer Guide>.


=head2 OriginShield => L<Paws::CloudFront::OriginShield>

CloudFront Origin Shield. Using Origin Shield can help reduce the load
on your origin.

For more information, see Using Origin Shield
(https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/origin-shield.html)
in the I<Amazon CloudFront Developer Guide>.


=head2 S3OriginConfig => L<Paws::CloudFront::S3OriginConfig>

Use this type to specify an origin that is an Amazon S3 bucket that is
not configured with static website hosting. To specify any other type
of origin, including an Amazon S3 bucket that is configured with static
website hosting, use the C<CustomOriginConfig> type instead.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::CloudFront>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

