# Generated by default/object.tt
package Paws::Appflow::DatadogConnectorProfileCredentials;
  use Moose;
  has ApiKey => (is => 'ro', isa => 'Str', request_name => 'apiKey', traits => ['NameInRequest'], required => 1);
  has ApplicationKey => (is => 'ro', isa => 'Str', request_name => 'applicationKey', traits => ['NameInRequest'], required => 1);

1;

### main pod documentation begin ###

=head1 NAME

Paws::Appflow::DatadogConnectorProfileCredentials

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Appflow::DatadogConnectorProfileCredentials object:

  $service_obj->Method(Att1 => { ApiKey => $value, ..., ApplicationKey => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Appflow::DatadogConnectorProfileCredentials object:

  $result = $service_obj->Method(...);
  $result->Att1->ApiKey

=head1 DESCRIPTION

The connector-specific credentials required by Datadog.

=head1 ATTRIBUTES


=head2 B<REQUIRED> ApiKey => Str

A unique alphanumeric identifier used to authenticate a user,
developer, or calling program to your API.


=head2 B<REQUIRED> ApplicationKey => Str

Application keys, in conjunction with your API key, give you full
access to DatadogE<rsquo>s programmatic API. Application keys are
associated with the user account that created them. The application key
is used to log all requests made to the API.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Appflow>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

