# Generated by default/object.tt
package Paws::ECS::EFSVolumeConfiguration;
  use Moose;
  has AuthorizationConfig => (is => 'ro', isa => 'Paws::ECS::EFSAuthorizationConfig', request_name => 'authorizationConfig', traits => ['NameInRequest']);
  has FileSystemId => (is => 'ro', isa => 'Str', request_name => 'fileSystemId', traits => ['NameInRequest'], required => 1);
  has RootDirectory => (is => 'ro', isa => 'Str', request_name => 'rootDirectory', traits => ['NameInRequest']);
  has TransitEncryption => (is => 'ro', isa => 'Str', request_name => 'transitEncryption', traits => ['NameInRequest']);
  has TransitEncryptionPort => (is => 'ro', isa => 'Int', request_name => 'transitEncryptionPort', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::ECS::EFSVolumeConfiguration

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::ECS::EFSVolumeConfiguration object:

  $service_obj->Method(Att1 => { AuthorizationConfig => $value, ..., TransitEncryptionPort => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::ECS::EFSVolumeConfiguration object:

  $result = $service_obj->Method(...);
  $result->Att1->AuthorizationConfig

=head1 DESCRIPTION

This parameter is specified when you are using an Amazon Elastic File
System file system for task storage. For more information, see Amazon
EFS Volumes
(https://docs.aws.amazon.com/AmazonECS/latest/developerguide/efs-volumes.html)
in the I<Amazon Elastic Container Service Developer Guide>.

=head1 ATTRIBUTES


=head2 AuthorizationConfig => L<Paws::ECS::EFSAuthorizationConfig>

The authorization configuration details for the Amazon EFS file system.


=head2 B<REQUIRED> FileSystemId => Str

The Amazon EFS file system ID to use.


=head2 RootDirectory => Str

The directory within the Amazon EFS file system to mount as the root
directory inside the host. If this parameter is omitted, the root of
the Amazon EFS volume will be used. Specifying C</> will have the same
effect as omitting this parameter.

If an EFS access point is specified in the C<authorizationConfig>, the
root directory parameter must either be omitted or set to C</> which
will enforce the path set on the EFS access point.


=head2 TransitEncryption => Str

Whether or not to enable encryption for Amazon EFS data in transit
between the Amazon ECS host and the Amazon EFS server. Transit
encryption must be enabled if Amazon EFS IAM authorization is used. If
this parameter is omitted, the default value of C<DISABLED> is used.
For more information, see Encrypting Data in Transit
(https://docs.aws.amazon.com/efs/latest/ug/encryption-in-transit.html)
in the I<Amazon Elastic File System User Guide>.


=head2 TransitEncryptionPort => Int

The port to use when sending encrypted data between the Amazon ECS host
and the Amazon EFS server. If you do not specify a transit encryption
port, it will use the port selection strategy that the Amazon EFS mount
helper uses. For more information, see EFS Mount Helper
(https://docs.aws.amazon.com/efs/latest/ug/efs-mount-helper.html) in
the I<Amazon Elastic File System User Guide>.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::ECS>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

