# Generated by default/object.tt
package Paws::GuardDuty::BucketPolicy;
  use Moose;
  has AllowsPublicReadAccess => (is => 'ro', isa => 'Bool', request_name => 'allowsPublicReadAccess', traits => ['NameInRequest']);
  has AllowsPublicWriteAccess => (is => 'ro', isa => 'Bool', request_name => 'allowsPublicWriteAccess', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::GuardDuty::BucketPolicy

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::GuardDuty::BucketPolicy object:

  $service_obj->Method(Att1 => { AllowsPublicReadAccess => $value, ..., AllowsPublicWriteAccess => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::GuardDuty::BucketPolicy object:

  $result = $service_obj->Method(...);
  $result->Att1->AllowsPublicReadAccess

=head1 DESCRIPTION

Contains information on the current bucket policies for the S3 bucket.

=head1 ATTRIBUTES


=head2 AllowsPublicReadAccess => Bool

A value that indicates whether public read access for the bucket is
enabled through a bucket policy.


=head2 AllowsPublicWriteAccess => Bool

A value that indicates whether public write access for the bucket is
enabled through a bucket policy.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::GuardDuty>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

