# Generated by default/object.tt
package Paws::MediaConvert::DvbSubDestinationSettings;
  use Moose;
  has Alignment => (is => 'ro', isa => 'Str', request_name => 'alignment', traits => ['NameInRequest']);
  has BackgroundColor => (is => 'ro', isa => 'Str', request_name => 'backgroundColor', traits => ['NameInRequest']);
  has BackgroundOpacity => (is => 'ro', isa => 'Int', request_name => 'backgroundOpacity', traits => ['NameInRequest']);
  has DdsHandling => (is => 'ro', isa => 'Str', request_name => 'ddsHandling', traits => ['NameInRequest']);
  has DdsXCoordinate => (is => 'ro', isa => 'Int', request_name => 'ddsXCoordinate', traits => ['NameInRequest']);
  has DdsYCoordinate => (is => 'ro', isa => 'Int', request_name => 'ddsYCoordinate', traits => ['NameInRequest']);
  has FontColor => (is => 'ro', isa => 'Str', request_name => 'fontColor', traits => ['NameInRequest']);
  has FontOpacity => (is => 'ro', isa => 'Int', request_name => 'fontOpacity', traits => ['NameInRequest']);
  has FontResolution => (is => 'ro', isa => 'Int', request_name => 'fontResolution', traits => ['NameInRequest']);
  has FontScript => (is => 'ro', isa => 'Str', request_name => 'fontScript', traits => ['NameInRequest']);
  has FontSize => (is => 'ro', isa => 'Int', request_name => 'fontSize', traits => ['NameInRequest']);
  has Height => (is => 'ro', isa => 'Int', request_name => 'height', traits => ['NameInRequest']);
  has OutlineColor => (is => 'ro', isa => 'Str', request_name => 'outlineColor', traits => ['NameInRequest']);
  has OutlineSize => (is => 'ro', isa => 'Int', request_name => 'outlineSize', traits => ['NameInRequest']);
  has ShadowColor => (is => 'ro', isa => 'Str', request_name => 'shadowColor', traits => ['NameInRequest']);
  has ShadowOpacity => (is => 'ro', isa => 'Int', request_name => 'shadowOpacity', traits => ['NameInRequest']);
  has ShadowXOffset => (is => 'ro', isa => 'Int', request_name => 'shadowXOffset', traits => ['NameInRequest']);
  has ShadowYOffset => (is => 'ro', isa => 'Int', request_name => 'shadowYOffset', traits => ['NameInRequest']);
  has SubtitlingType => (is => 'ro', isa => 'Str', request_name => 'subtitlingType', traits => ['NameInRequest']);
  has TeletextSpacing => (is => 'ro', isa => 'Str', request_name => 'teletextSpacing', traits => ['NameInRequest']);
  has Width => (is => 'ro', isa => 'Int', request_name => 'width', traits => ['NameInRequest']);
  has XPosition => (is => 'ro', isa => 'Int', request_name => 'xPosition', traits => ['NameInRequest']);
  has YPosition => (is => 'ro', isa => 'Int', request_name => 'yPosition', traits => ['NameInRequest']);

1;

### main pod documentation begin ###

=head1 NAME

Paws::MediaConvert::DvbSubDestinationSettings

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::MediaConvert::DvbSubDestinationSettings object:

  $service_obj->Method(Att1 => { Alignment => $value, ..., YPosition => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::MediaConvert::DvbSubDestinationSettings object:

  $result = $service_obj->Method(...);
  $result->Att1->Alignment

=head1 DESCRIPTION

Settings related to DVB-Sub captions. Set up DVB-Sub captions in the
same output as your video. For more information, see
https://docs.aws.amazon.com/mediaconvert/latest/ug/dvb-sub-output-captions.html.
When you work directly in your JSON job specification, include this
object and any required children when you set destinationType to
DVB_SUB.

=head1 ATTRIBUTES


=head2 Alignment => Str

If no explicit x_position or y_position is provided, setting alignment
to centered will place the captions at the bottom center of the output.
Similarly, setting a left alignment will align captions to the bottom
left of the output. If x and y positions are given in conjunction with
the alignment parameter, the font will be justified (either left or
centered) relative to those coordinates. This option is not valid for
source captions that are STL, 608/embedded or teletext. These source
settings are already pre-defined by the caption stream. All burn-in and
DVB-Sub font settings must match.


=head2 BackgroundColor => Str

Specifies the color of the rectangle behind the captions. All burn-in
and DVB-Sub font settings must match.


=head2 BackgroundOpacity => Int

Specifies the opacity of the background rectangle. 255 is opaque; 0 is
transparent. Leaving this parameter blank is equivalent to setting it
to 0 (transparent). All burn-in and DVB-Sub font settings must match.


=head2 DdsHandling => Str

Specify how MediaConvert handles the display definition segment (DDS).
Keep the default, None (NONE), to exclude the DDS from this set of
captions. Choose No display window (NO_DISPLAY_WINDOW) to have
MediaConvert include the DDS but not include display window data. In
this case, MediaConvert writes that information to the page composition
segment (PCS) instead. Choose Specify (SPECIFIED) to have MediaConvert
set up the display window based on the values that you specify in
related job settings. For video resolutions that are 576 pixels or
smaller in height, MediaConvert doesn't include the DDS, regardless of
the value you choose for DDS handling (ddsHandling). In this case, it
doesn't write the display window data to the PCS either. Related
settings: Use the settings DDS x-coordinate (ddsXCoordinate) and DDS
y-coordinate (ddsYCoordinate) to specify the offset between the top
left corner of the display window and the top left corner of the video
frame. All burn-in and DVB-Sub font settings must match.


=head2 DdsXCoordinate => Int

Use this setting, along with DDS y-coordinate (ddsYCoordinate), to
specify the upper left corner of the display definition segment (DDS)
display window. With this setting, specify the distance, in pixels,
between the left side of the frame and the left side of the DDS display
window. Keep the default value, 0, to have MediaConvert automatically
choose this offset. Related setting: When you use this setting, you
must set DDS handling (ddsHandling) to a value other than None (NONE).
MediaConvert uses these values to determine whether to write page
position data to the DDS or to the page composition segment (PCS). All
burn-in and DVB-Sub font settings must match.


=head2 DdsYCoordinate => Int

Use this setting, along with DDS x-coordinate (ddsXCoordinate), to
specify the upper left corner of the display definition segment (DDS)
display window. With this setting, specify the distance, in pixels,
between the top of the frame and the top of the DDS display window.
Keep the default value, 0, to have MediaConvert automatically choose
this offset. Related setting: When you use this setting, you must set
DDS handling (ddsHandling) to a value other than None (NONE).
MediaConvert uses these values to determine whether to write page
position data to the DDS or to the page composition segment (PCS). All
burn-in and DVB-Sub font settings must match.


=head2 FontColor => Str

Specifies the color of the burned-in captions. This option is not valid
for source captions that are STL, 608/embedded or teletext. These
source settings are already pre-defined by the caption stream. All
burn-in and DVB-Sub font settings must match.


=head2 FontOpacity => Int

Specifies the opacity of the burned-in captions. 255 is opaque; 0 is
transparent. All burn-in and DVB-Sub font settings must match.


=head2 FontResolution => Int

Font resolution in DPI (dots per inch); default is 96 dpi. All burn-in
and DVB-Sub font settings must match.


=head2 FontScript => Str

Provide the font script, using an ISO 15924 script code, if the
LanguageCode is not sufficient for determining the script type. Where
LanguageCode or CustomLanguageCode is sufficient, use "AUTOMATIC" or
leave unset. This is used to help determine the appropriate font for
rendering DVB-Sub captions.


=head2 FontSize => Int

A positive integer indicates the exact font size in points. Set to 0
for automatic font size selection. All burn-in and DVB-Sub font
settings must match.


=head2 Height => Int

Specify the height, in pixels, of this set of DVB-Sub captions. The
default value is 576 pixels. Related setting: When you use this
setting, you must set DDS handling (ddsHandling) to a value other than
None (NONE). All burn-in and DVB-Sub font settings must match.


=head2 OutlineColor => Str

Specifies font outline color. This option is not valid for source
captions that are either 608/embedded or teletext. These source
settings are already pre-defined by the caption stream. All burn-in and
DVB-Sub font settings must match.


=head2 OutlineSize => Int

Specifies font outline size in pixels. This option is not valid for
source captions that are either 608/embedded or teletext. These source
settings are already pre-defined by the caption stream. All burn-in and
DVB-Sub font settings must match.


=head2 ShadowColor => Str

Specifies the color of the shadow cast by the captions. All burn-in and
DVB-Sub font settings must match.


=head2 ShadowOpacity => Int

Specifies the opacity of the shadow. 255 is opaque; 0 is transparent.
Leaving this parameter blank is equivalent to setting it to 0
(transparent). All burn-in and DVB-Sub font settings must match.


=head2 ShadowXOffset => Int

Specifies the horizontal offset of the shadow relative to the captions
in pixels. A value of -2 would result in a shadow offset 2 pixels to
the left. All burn-in and DVB-Sub font settings must match.


=head2 ShadowYOffset => Int

Specifies the vertical offset of the shadow relative to the captions in
pixels. A value of -2 would result in a shadow offset 2 pixels above
the text. All burn-in and DVB-Sub font settings must match.


=head2 SubtitlingType => Str

Specify whether your DVB subtitles are standard or for hearing
impaired. Choose hearing impaired if your subtitles include audio
descriptions and dialogue. Choose standard if your subtitles include
only dialogue.


=head2 TeletextSpacing => Str

Only applies to jobs with input captions in Teletext or STL formats.
Specify whether the spacing between letters in your captions is set by
the captions grid or varies depending on letter width. Choose fixed
grid to conform to the spacing specified in the captions file more
accurately. Choose proportional to make the text easier to read if the
captions are closed caption.


=head2 Width => Int

Specify the width, in pixels, of this set of DVB-Sub captions. The
default value is 720 pixels. Related setting: When you use this
setting, you must set DDS handling (ddsHandling) to a value other than
None (NONE). All burn-in and DVB-Sub font settings must match.


=head2 XPosition => Int

Specifies the horizontal position of the caption relative to the left
side of the output in pixels. A value of 10 would result in the
captions starting 10 pixels from the left of the output. If no explicit
x_position is provided, the horizontal caption position will be
determined by the alignment parameter. This option is not valid for
source captions that are STL, 608/embedded or teletext. These source
settings are already pre-defined by the caption stream. All burn-in and
DVB-Sub font settings must match.


=head2 YPosition => Int

Specifies the vertical position of the caption relative to the top of
the output in pixels. A value of 10 would result in the captions
starting 10 pixels from the top of the output. If no explicit
y_position is provided, the caption will be positioned towards the
bottom of the output. This option is not valid for source captions that
are STL, 608/embedded or teletext. These source settings are already
pre-defined by the caption stream. All burn-in and DVB-Sub font
settings must match.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::MediaConvert>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

