# Generated by default/object.tt
package Paws::Transfer::DescribedUser;
  use Moose;
  has Arn => (is => 'ro', isa => 'Str', required => 1);
  has HomeDirectory => (is => 'ro', isa => 'Str');
  has HomeDirectoryMappings => (is => 'ro', isa => 'ArrayRef[Paws::Transfer::HomeDirectoryMapEntry]');
  has HomeDirectoryType => (is => 'ro', isa => 'Str');
  has Policy => (is => 'ro', isa => 'Str');
  has PosixProfile => (is => 'ro', isa => 'Paws::Transfer::PosixProfile');
  has Role => (is => 'ro', isa => 'Str');
  has SshPublicKeys => (is => 'ro', isa => 'ArrayRef[Paws::Transfer::SshPublicKey]');
  has Tags => (is => 'ro', isa => 'ArrayRef[Paws::Transfer::Tag]');
  has UserName => (is => 'ro', isa => 'Str');

1;

### main pod documentation begin ###

=head1 NAME

Paws::Transfer::DescribedUser

=head1 USAGE

This class represents one of two things:

=head3 Arguments in a call to a service

Use the attributes of this class as arguments to methods. You shouldn't make instances of this class. 
Each attribute should be used as a named argument in the calls that expect this type of object.

As an example, if Att1 is expected to be a Paws::Transfer::DescribedUser object:

  $service_obj->Method(Att1 => { Arn => $value, ..., UserName => $value  });

=head3 Results returned from an API call

Use accessors for each attribute. If Att1 is expected to be an Paws::Transfer::DescribedUser object:

  $result = $service_obj->Method(...);
  $result->Att1->Arn

=head1 DESCRIPTION

Describes the properties of a user that was specified.

=head1 ATTRIBUTES


=head2 B<REQUIRED> Arn => Str

Specifies the unique Amazon Resource Name (ARN) for the user that was
requested to be described.


=head2 HomeDirectory => Str

The landing directory (folder) for a user when they log in to the
server using the client.

A C<HomeDirectory> example is C</bucket_name/home/mydirectory>.


=head2 HomeDirectoryMappings => ArrayRef[L<Paws::Transfer::HomeDirectoryMapEntry>]

Logical directory mappings that specify what Amazon S3 or Amazon EFS
paths and keys should be visible to your user and how you want to make
them visible. You must specify the C<Entry> and C<Target> pair, where
C<Entry> shows how the path is made visible and C<Target> is the actual
Amazon S3 or Amazon EFS path. If you only specify a target, it is
displayed as is. You also must ensure that your Amazon Web Services
Identity and Access Management (IAM) role provides access to paths in
C<Target>. This value can only be set when C<HomeDirectoryType> is set
to I<LOGICAL>.

In most cases, you can use this value instead of the scope-down policy
to lock your user down to the designated home directory ("C<chroot>").
To do this, you can set C<Entry> to '/' and set C<Target> to the
HomeDirectory parameter value.


=head2 HomeDirectoryType => Str

The type of landing directory (folder) you want your users' home
directory to be when they log into the server. If you set it to
C<PATH>, the user will see the absolute Amazon S3 bucket or EFS paths
as is in their file transfer protocol clients. If you set it
C<LOGICAL>, you will need to provide mappings in the
C<HomeDirectoryMappings> for how you want to make Amazon S3 or EFS
paths visible to your users.


=head2 Policy => Str

A scope-down policy for your user so that you can use the same IAM role
across multiple users. This policy scopes down user access to portions
of their Amazon S3 bucket. Variables that you can use inside this
policy include C<${Transfer:UserName}>, C<${Transfer:HomeDirectory}>,
and C<${Transfer:HomeBucket}>.


=head2 PosixProfile => L<Paws::Transfer::PosixProfile>

Specifies the full POSIX identity, including user ID (C<Uid>), group ID
(C<Gid>), and any secondary groups IDs (C<SecondaryGids>), that
controls your users' access to your Amazon Elastic File System (Amazon
EFS) file systems. The POSIX permissions that are set on files and
directories in your file system determine the level of access your
users get when transferring files into and out of your Amazon EFS file
systems.


=head2 Role => Str

Specifies the Amazon Resource Name (ARN) of the IAM role that controls
your users' access to your Amazon S3 bucket or EFS file system. The
policies attached to this role determine the level of access that you
want to provide your users when transferring files into and out of your
Amazon S3 bucket or EFS file system. The IAM role should also contain a
trust relationship that allows the server to access your resources when
servicing your users' transfer requests.


=head2 SshPublicKeys => ArrayRef[L<Paws::Transfer::SshPublicKey>]

Specifies the public key portion of the Secure Shell (SSH) keys stored
for the described user.


=head2 Tags => ArrayRef[L<Paws::Transfer::Tag>]

Specifies the key-value pairs for the user requested. Tag can be used
to search for and group users for a variety of purposes.


=head2 UserName => Str

Specifies the name of the user that was requested to be described. User
names are used for authentication purposes. This is the string that
will be used by your user when they log in to your server.



=head1 SEE ALSO

This class forms part of L<Paws>, describing an object used in L<Paws::Transfer>

=head1 BUGS and CONTRIBUTIONS

The source code is located here: L<https://github.com/pplu/aws-sdk-perl>

Please report bugs to: L<https://github.com/pplu/aws-sdk-perl/issues>

=cut

