package Foo::Auth; # $Id$
use strict;

=head1 NAME

Foo::Auth - Auth (login/logout) controller

=head1 VERSION

Version 1.00

=head1 DESCRIPTION

Auth (login/logout) controller

=cut

use CTK::Util qw/ :BASE/;

sub meta {(
    login => { # 
        handler => {
            access  => sub {1},
            form    => [ \&Foo::before_view, \&login_form, \&Foo::after_view, ],
            deny    => sub {1},
            chck    => \&login_chck,
            proc    => \&login_proc,
        },
        description     => "LogIn controller",
        session_enable  => 1,
    },
    logout => { # 
        handler => {
            access  => sub {1},
            form    => sub {print shift->q->redirect(-uri=>'/',-status => 302); 302},
            deny    => sub {1},
            chck    => sub {1},
            proc    => \&logout_proc,
        },
        description     => "LogOut controller",
        tplfile         => "shtml/login.shtml",
        session_enable  => 1,
    },
)}

sub login_form {
    my $self = shift;
    my $template    = $self->template;
    my $h           = $self->h;
    my $authssn     = $self->authssn;

    my $access = $authssn->access;
    my $status = $authssn->status;
    my $reason = $authssn->reason;
    my $serror = $authssn->error;
    
    $h->{status}    = $status;
    $h->{reason}    = $reason;
    $h->{reason_ru} = $authssn->reason_translate;
    $h->{serror}    = $serror;
    $h->{ctime}     = $authssn->get_ctime ? localtime2date_time($authssn->get_ctime) : '-';
    $h->{atime}     = $authssn->get_atime ? localtime2date_time($authssn->get_atime) : '-';
    $h->{expires}   = $authssn->get_atime ? localtime2date_time($authssn->get_atime + $authssn->get_expires) : '+'.$authssn->get_expires;

    1;
}
sub login_chck { #       !
    my $self = shift;
    my $usr     = $self->usr;
    my $error   = $self->error;
    
    push @$error, to_utf8("Login mismatch!") unless $usr->{login};
    push @$error, to_utf8("Password mismatch!") unless $usr->{password};
  
    return @$error ? 0 : 1
}
sub login_proc {
    my $self = shift;
    my $q       = $self->q;
    my $usr     = $self->usr;
    my $error   = $self->error;
    my $authssn = $self->authssn;
    my $config  = $self->config;
    
    # 
    unless ($authssn->authen( sub { # AAA-authen
        my $self = shift;
        my $login = shift || '';
        my $password = shift || '';
    
        #  
        $self->reason("LOGIN_INCORRECT") && return unless $login;
        $self->reason("PASSWORD_INCORRECT") && return unless $password;
        
        #  
        my %users = (
                foo => "123", # Allow
                bar => "123", # Allow
                baz => "123", # Deny
            );
        #     
        $self->reason("DECLINED") && return unless $users{$login} && $users{$login} eq $password;
    
        #    
        $self->set(login => $login); #  
    
        return 1;
    }, $usr->{login}, $usr->{password} )) {
        push @$error, sprintf("%s: %s",$authssn->reason, $authssn->reason_translate);
        return 0;
    }

    # 
    unless ($authssn->authz( sub { # AAA-authz
        my $self = shift;
        my $login = $self->get("login") || '';
    
        #    ..   
        $self->reason("FORBIDDEN") && return if $login eq 'baz';
        
        return 1;
    } )) {
        push @$error, sprintf("%s: %s",$authssn->reason, $authssn->reason_translate);
        return 0;
    }
    
    #     
    $authssn->set(test  => 'Blah-Blah-Blah');
   
    #   cookie
    my $cookie = $q->cookie(
        -name       => $authssn->{sidkey},
        -value      => $authssn->sid,
        -expires    => '+5y',
        #-path       => '/',
        #-domain    => '.localhost',
        #-secure    => 1, #  SSL
    );

    print "P3P: CP=\"BUS CUR CONo FIN IVDo ONL OUR PHY SAMo TELo\"\n";
    print $q->redirect(
        -uri    => '?action=login',
        -cookie => $cookie,
        -status => 302,
    );
    return 302;
}
sub logout_proc {
    my $self = shift;
    my $q       = $self->q;
    my $authssn = $self->authssn;

    $authssn->delete; #   
    my $cookie = $q->cookie(
        -name       => $authssn->{sidkey},
        -value      => '',
        -expires    => '+1s',
        #-path       => '/',
        #-domain    => '.localhost',
        #-secure    => 1, #  SSL
    );
    
    print "P3P: CP=\"BUS CUR CONo FIN IVDo ONL OUR PHY SAMo TELo\"\n";
    print $q->redirect(
        -uri=>'?action=default',
        -cookie=>$cookie,
        -status => 302,
    );
    return 302;
}

1;
__END__
