#!/usr/bin/perl

package eBay::API::XML::Call::ReviseCheckoutStatus::ReviseCheckoutStatusRequestType;

use strict;
use warnings;  

##########################################################################
#
# Module: ............... <user defined location>eBay/API/XML
# File: ................. ReviseCheckoutStatusRequestType.pm
# Generated by: ......... genEBayApiDataTypes.pl
# Last Generated: ....... 08/24/2008 16:44
# API Release Number: ... 579
#
##########################################################################  

=head1 NAME

eBay::API::XML::Call::ReviseCheckoutStatus::ReviseCheckoutStatusRequestType

=head1 DESCRIPTION

Enables a seller to update the payment status of an item.



=head1 SYNOPSIS

=cut


=head1 INHERITANCE

eBay::API::XML::Call::ReviseCheckoutStatus::ReviseCheckoutStatusRequestType inherits from the L<eBay::API::XML::RequestDataType> class

=cut

use eBay::API::XML::RequestDataType;
our @ISA = ("eBay::API::XML::RequestDataType");

use eBay::API::XML::DataType::AddressType;
use eBay::API::XML::DataType::AmountType;
use eBay::API::XML::DataType::ExternalTransactionType;
use eBay::API::XML::DataType::ItemIDType;
use eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType;
use eBay::API::XML::DataType::Enum::CheckoutMethodCodeType;
use eBay::API::XML::DataType::Enum::CompleteStatusCodeType;
use eBay::API::XML::DataType::Enum::InsuranceSelectedCodeType;
use eBay::API::XML::DataType::Enum::RCSPaymentStatusCodeType;


my @gaProperties = ( [ 'AdjustmentAmount', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'AmountPaid', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'BuyerID', 'xs:string', '', '', '' ]
	, [ 'CODCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'CheckoutMethod', 'ns:CheckoutMethodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CheckoutMethodCodeType', '' ]
	, [ 'CheckoutStatus', 'ns:CompleteStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::CompleteStatusCodeType', '' ]
	, [ 'EncryptedID', 'xs:string', '', '', '' ]
	, [ 'ExternalTransaction', 'ns:ExternalTransactionType', ''
	     ,'eBay::API::XML::DataType::ExternalTransactionType', '1' ]
	, [ 'InsuranceType', 'ns:InsuranceSelectedCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::InsuranceSelectedCodeType', '' ]
	, [ 'ItemID', 'ns:ItemIDType', ''
	     ,'eBay::API::XML::DataType::ItemIDType', '1' ]
	, [ 'MultipleSellerPaymentID', 'xs:string', '', '', '' ]
	, [ 'OrderID', 'xs:string', '', '', '' ]
	, [ 'PaymentMethodUsed', 'ns:BuyerPaymentMethodCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::BuyerPaymentMethodCodeType', '' ]
	, [ 'PaymentStatus', 'ns:RCSPaymentStatusCodeType', ''
	     ,'eBay::API::XML::DataType::Enum::RCSPaymentStatusCodeType', '' ]
	, [ 'SalesTax', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ShippingAddress', 'ns:AddressType', ''
	     ,'eBay::API::XML::DataType::AddressType', '1' ]
	, [ 'ShippingCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ShippingIncludedInTax', 'xs:boolean', '', '', '' ]
	, [ 'ShippingInsuranceCost', 'ns:AmountType', ''
	     ,'eBay::API::XML::DataType::AmountType', '1' ]
	, [ 'ShippingService', 'xs:token', '', '', '' ]
	, [ 'TransactionID', 'xs:string', '', '', '' ]
                    );
push @gaProperties, @{eBay::API::XML::RequestDataType::getPropertiesList()};

my @gaAttributes = ( 
                    );
push @gaAttributes, @{eBay::API::XML::RequestDataType::getAttributesList()};

=head1 Subroutines:

=cut

sub new {
  my $classname = shift;
  my %args = @_;
  my $self = $classname->SUPER::new(%args);
  return $self;
}

sub isScalar {
   return 0; 
}



=head2 setAdjustmentAmount()

Discount or charge agreed to by the buyer and seller. A positive value
indicates that the amount is an extra charge being paid to the seller by
the buyer. A negative value indicates that the amount is a discount given
to the buyer by the seller.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setAdjustmentAmount {
  my $self = shift;
  $self->{'AdjustmentAmount'} = shift
}

=head2 getAdjustmentAmount()

#    Returns: 'ns:AmountType'

=cut

sub getAdjustmentAmount {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AdjustmentAmount'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setAmountPaid()

The amount paid by the buyer. For an eBay Stores item, the value passed in
AmountPaid is the transaction/item price. For a US eBay Motors item,
AmountPaid is the total amount paid by the buyer for the deposit.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setAmountPaid {
  my $self = shift;
  $self->{'AmountPaid'} = shift
}

=head2 getAmountPaid()

#    Returns: 'ns:AmountType'

=cut

sub getAmountPaid {
  my $self = shift;
  return $self->_getDataTypeInstance( 'AmountPaid'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setBuyerID()

eBay ID for the buyer in the transaction being revised. A transaction is
uniquely identified by one of two means: (a) You provide a TransactionID
and ItemID. (This is the preferred approach.), OR, (b) You provide a
BuyerID and ItemID and eBay identifies only one transaction for that
combination (an error is returned if there are multiple transactions for
that combination). Note: If all three are provided (that is, BuyerID,
ItemID and TransactionID), BuyerID is ignored.

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setBuyerID {
  my $self = shift;
  $self->{'BuyerID'} = shift
}

=head2 getBuyerID()

#    Returns: 'xs:string'

=cut

sub getBuyerID {
  my $self = shift;
  return $self->{'BuyerID'};
}


=head2 setCODCost()

Italy site (site ID 101) only.
Enables you to specify the cash-on-delivery (COD) cost, for COD shipping.

SeeLink: URL: http://developer.ebay.com/DevZone/XML/docs/WebHelp/index.htm?context=eBay_XML_API&topic=CODInShippingDetails
Title: Specifying the Cash on Delivery Option in Shipping Details

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setCODCost {
  my $self = shift;
  $self->{'CODCost'} = shift
}

=head2 getCODCost()

#    Returns: 'ns:AmountType'

=cut

sub getCODCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'CODCost'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setCheckoutMethod()

Not supported.

  RequiredInput: No
#    Argument: 'ns:CheckoutMethodCodeType'

=cut

sub setCheckoutMethod {
  my $self = shift;
  $self->{'CheckoutMethod'} = shift
}

=head2 getCheckoutMethod()

#    Returns: 'ns:CheckoutMethodCodeType'

=cut

sub getCheckoutMethod {
  my $self = shift;
  return $self->{'CheckoutMethod'};
}


=head2 setCheckoutStatus()

The current status of the checkout process for the transaction.

  RequiredInput: Yes
#    Argument: 'ns:CompleteStatusCodeType'

=cut

sub setCheckoutStatus {
  my $self = shift;
  $self->{'CheckoutStatus'} = shift
}

=head2 getCheckoutStatus()

#    Returns: 'ns:CompleteStatusCodeType'

=cut

sub getCheckoutStatus {
  my $self = shift;
  return $self->{'CheckoutStatus'};
}


=head2 setEncryptedID()

Not supported.

MaxLength: 20

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setEncryptedID {
  my $self = shift;
  $self->{'EncryptedID'} = shift
}

=head2 getEncryptedID()

#    Returns: 'xs:string'

=cut

sub getEncryptedID {
  my $self = shift;
  return $self->{'EncryptedID'};
}


=head2 setExternalTransaction()

Not supported.

  RequiredInput: No
#    Argument: 'ns:ExternalTransactionType'

=cut

sub setExternalTransaction {
  my $self = shift;
  $self->{'ExternalTransaction'} = shift
}

=head2 getExternalTransaction()

#    Returns: 'ns:ExternalTransactionType'

=cut

sub getExternalTransaction {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ExternalTransaction'
		,'eBay::API::XML::DataType::ExternalTransactionType');
}


=head2 setInsuranceType()

The insurance option selected by the buyer.

  RequiredInput: No
#    Argument: 'ns:InsuranceSelectedCodeType'

=cut

sub setInsuranceType {
  my $self = shift;
  $self->{'InsuranceType'} = shift
}

=head2 getInsuranceType()

#    Returns: 'ns:InsuranceSelectedCodeType'

=cut

sub getInsuranceType {
  my $self = shift;
  return $self->{'InsuranceType'};
}


=head2 setItemID()

Unique ID for the item associated with the checkout. A transaction is
uniquely identified by one of two means: (a) You provide a TransactionID
and ItemID. (This is the preferred approach.), OR, (b) You provide a
BuyerID and ItemID and eBay identifies only one transaction for that
combination (an error is returned if there are multiple transactions for
that combination). Note: If all three are provided (that is, BuyerID,
ItemID and TransactionID), BuyerID is ignored.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, Item IDs are usually 9 to 12 digits)

  RequiredInput: Yes
#    Argument: 'ns:ItemIDType'

=cut

sub setItemID {
  my $self = shift;
  $self->{'ItemID'} = shift
}

=head2 getItemID()

#    Returns: 'ns:ItemIDType'

=cut

sub getItemID {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ItemID'
		,'eBay::API::XML::DataType::ItemIDType');
}


=head2 setMultipleSellerPaymentID()

Not supported.

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setMultipleSellerPaymentID {
  my $self = shift;
  $self->{'MultipleSellerPaymentID'} = shift
}

=head2 getMultipleSellerPaymentID()

#    Returns: 'xs:string'

=cut

sub getMultipleSellerPaymentID {
  my $self = shift;
  return $self->{'MultipleSellerPaymentID'};
}


=head2 setOrderID()

Unique ID for a multi-item order. If specified, ItemID and
TransactionID are ignored if specified in the same call.
Changes to the checkout status are applied to the specified
order as a whole (and thus the child transactions
associated with the order).

  RequiredInput: No
#    Argument: 'xs:string'

=cut

sub setOrderID {
  my $self = shift;
  $self->{'OrderID'} = shift
}

=head2 getOrderID()

#    Returns: 'xs:string'

=cut

sub getOrderID {
  my $self = shift;
  return $self->{'OrderID'};
}


=head2 setPaymentMethodUsed()

Payment method used by the buyer.
Required if CheckoutStatus is Complete.
(Please note that only PayPal can set this value to PayPal.)
<br>
<span class="tablenote"><b>Note:</b>
Required or allowed payment methods vary by site and category. Refer to
<a href="http://developer.ebay.com/DevZone/XML/docs/WebHelp/wwhelp/wwhimpl/js/html/wwhelp.htm?context=eBay_XML_API&topic=PaymentMethodDifferences">
Payment Method Differences (PaymentMethod)</a> in the eBay
Trading API Guide for information to help you determine which payment
methods you are required or allowed to specify.
</span><br>
<br>

AllValuesExcept: PayPal

  RequiredInput: Conditionally
#    Argument: 'ns:BuyerPaymentMethodCodeType'

=cut

sub setPaymentMethodUsed {
  my $self = shift;
  $self->{'PaymentMethodUsed'} = shift
}

=head2 getPaymentMethodUsed()

#    Returns: 'ns:BuyerPaymentMethodCodeType'

=cut

sub getPaymentMethodUsed {
  my $self = shift;
  return $self->{'PaymentMethodUsed'};
}


=head2 setPaymentStatus()

Not supported.

  RequiredInput: No
#    Argument: 'ns:RCSPaymentStatusCodeType'

=cut

sub setPaymentStatus {
  my $self = shift;
  $self->{'PaymentStatus'} = shift
}

=head2 getPaymentStatus()

#    Returns: 'ns:RCSPaymentStatusCodeType'

=cut

sub getPaymentStatus {
  my $self = shift;
  return $self->{'PaymentStatus'};
}


=head2 setSalesTax()

Amount of money paid for sales tax. For Third-Party Checkout
applications.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setSalesTax {
  my $self = shift;
  $self->{'SalesTax'} = shift
}

=head2 getSalesTax()

#    Returns: 'ns:AmountType'

=cut

sub getSalesTax {
  my $self = shift;
  return $self->_getDataTypeInstance( 'SalesTax'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setShippingAddress()

For internal use.

  RequiredInput: No
#    Argument: 'ns:AddressType'

=cut

sub setShippingAddress {
  my $self = shift;
  $self->{'ShippingAddress'} = shift
}

=head2 getShippingAddress()

#    Returns: 'ns:AddressType'

=cut

sub getShippingAddress {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingAddress'
		,'eBay::API::XML::DataType::AddressType');
}


=head2 setShippingCost()

Amount of money paid for shipping. For Third-party Checkout
applications.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setShippingCost {
  my $self = shift;
  $self->{'ShippingCost'} = shift
}

=head2 getShippingCost()

#    Returns: 'ns:AmountType'

=cut

sub getShippingCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingCost'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setShippingIncludedInTax()

An indicator of whether shipping costs were included in the
taxable amount. For Third-Party Checkout applications.

Default: false

  RequiredInput: No
#    Argument: 'xs:boolean'

=cut

sub setShippingIncludedInTax {
  my $self = shift;
  $self->{'ShippingIncludedInTax'} = shift
}

=head2 isShippingIncludedInTax()

#    Returns: 'xs:boolean'

=cut

sub isShippingIncludedInTax {
  my $self = shift;
  return $self->{'ShippingIncludedInTax'};
}


=head2 setShippingInsuranceCost()

Amount of money paid for insurance. For Third Party Checkout
applications.

  RequiredInput: No
#    Argument: 'ns:AmountType'

=cut

sub setShippingInsuranceCost {
  my $self = shift;
  $self->{'ShippingInsuranceCost'} = shift
}

=head2 getShippingInsuranceCost()

#    Returns: 'ns:AmountType'

=cut

sub getShippingInsuranceCost {
  my $self = shift;
  return $self->_getDataTypeInstance( 'ShippingInsuranceCost'
		,'eBay::API::XML::DataType::AmountType');
}


=head2 setShippingService()

The shipping service selected by the buyer from among the shipping
services offered by the seller (such as UPS Ground). For a list of valid
values that you can cache for future use, call GeteBayDetails with
DetailName set to ShippingServiceDetails.

  RequiredInput: No
#    Argument: 'xs:token'

=cut

sub setShippingService {
  my $self = shift;
  $self->{'ShippingService'} = shift
}

=head2 getShippingService()

#    Returns: 'xs:token'

=cut

sub getShippingService {
  my $self = shift;
  return $self->{'ShippingService'};
}


=head2 setTransactionID()

Unique ID for the transaction associated with the checkout. For Chinese
auctions, the value passed in the TransactionID argument must be 0 or the
call will fail with an error. For all other auction types, TransactionID
accepts the actual, nonzero transaction ID. Call GetItemTransactionsCall
or GetSellerTransactionsCall to determine the correct transaction ID. A
transaction is uniquely identified by one of two means: (a) You provide a
TransactionID and ItemID. (This is the preferred approach.), OR, (b) You
provide a BuyerID and ItemID and eBay identifies only one transaction for
that combination (an error is returned if there are multiple transactions
for that combination). Note: If all three are provided (that is, BuyerID,
ItemID and TransactionID), BuyerID is ignored.

MaxLength: 19 (Note: The eBay database specifies 38. Currently, transaction IDs are usually 9 to 12 digits.)

  RequiredInput: Conditionally
#    Argument: 'xs:string'

=cut

sub setTransactionID {
  my $self = shift;
  $self->{'TransactionID'} = shift
}

=head2 getTransactionID()

#    Returns: 'xs:string'

=cut

sub getTransactionID {
  my $self = shift;
  return $self->{'TransactionID'};
}





##  Attribute and Property lists
sub getPropertiesList {
   my $self = shift;
   return \@gaProperties;
}

sub getAttributesList {
   my $self = shift;
   return \@gaAttributes;
}



1;   
