#ifndef YAML_GRAMMAR_C
#define YAML_GRAMMAR_C

const static char *yamls = "\n"
  "event ^start_of_line = predicted <start of line>\n"
  "event ^end_of_input = predicted <end of input>\n"
  "event ^empty = predicted <empty>\n"
  "event ^c_printable = predicted <c printable>\n"
  "event ^nb_json = predicted <nb json>\n"
  "event ^c_byte_order_mark = predicted <c byte order mark>\n"
  "event ^c_sequence_entry = predicted <c sequence entry>\n"
  "event ^c_mapping_key = predicted <c mapping key>\n"
  "event ^c_mapping_value = predicted <c mapping value>\n"
  "event ^c_collect_entry = predicted <c collect entry>\n"
  "event ^c_sequence_start = predicted <c sequence start>\n"
  "event ^c_sequence_end = predicted <c sequence end>\n"
  "event ^c_mapping_start = predicted <c mapping start>\n"
  "event ^c_mapping_end = predicted <c mapping end>\n"
  "event ^c_comment = predicted <c comment>\n"
  "event ^c_anchor = predicted <c anchor>\n"
  "event ^c_alias = predicted <c alias>\n"
  "event ^c_tag = predicted <c tag>\n"
  "event ^c_literal = predicted <c literal>\n"
  "event ^c_folded = predicted <c folded>\n"
  "event ^c_single_quote = predicted <c single quote>\n"
  "event ^c_double_quote = predicted <c double quote>\n"
  "event ^c_directive = predicted <c directive>\n"
  "event ^c_reserved = predicted <c reserved>\n"
  "event ^c_indicator = predicted <c indicator>\n"
  "event ^c_flow_indicator = predicted <c flow indicator>\n"
  "event ^b_line_feed = predicted <b line feed>\n"
  "event ^b_carriage_return = predicted <b carriage return>\n"
  "event ^b_char = predicted <b char>\n"
  "event ^nb_char = predicted <nb char>\n"
  "event ^b_break = predicted <b break>\n"
  "event ^b_as_line_feed = predicted <b as line feed>\n"
  "event ^b_non_content = predicted <b non content>\n"
  "event ^s_space = predicted <s space>\n"
  "event ^s_tab = predicted <s tab>\n"
  "event ^s_white = predicted <s white>\n"
  "event ^ns_char = predicted <ns char>\n"
  "event ^ns_dec_digit = predicted <ns dec digit>\n"
  "event ^ns_hex_digit = predicted <ns hex digit>\n"
  "event ^ns_ascii_letter = predicted <ns ascii letter>\n"
  "event ^ns_word_char = predicted <ns word char>\n"
  "event ^ns_uri_char = predicted <ns uri char>\n"
  "event ^ns_tag_char = predicted <ns tag char>\n"
  "event ^c_escape = predicted <c escape>\n"
  "event ^ns_esc_null = predicted <ns esc null>\n"
  "event ^ns_esc_bell = predicted <ns esc bell>\n"
  "event ^ns_esc_backspace = predicted <ns esc backspace>\n"
  "event ^ns_esc_horizontal_tab = predicted <ns esc horizontal tab>\n"
  "event ^ns_esc_line_feed = predicted <ns esc line feed>\n"
  "event ^ns_esc_vertical_tab = predicted <ns esc vertical tab>\n"
  "event ^ns_esc_form_feed = predicted <ns esc form feed>\n"
  "event ^ns_esc_carriage_return = predicted <ns esc carriage return>\n"
  "event ^ns_esc_escape = predicted <ns esc escape>\n"
  "event ^ns_esc_double_quote = predicted <ns esc double quote>\n"
  "event ^ns_esc_slash = predicted <ns esc slash>\n"
  "event ^ns_esc_backslash = predicted <ns esc backslash>\n"
  "event ^ns_esc_next_line = predicted <ns esc next line>\n"
  "event ^ns_esc_non_breaking_space = predicted <ns esc non breaking space>\n"
  "event ^ns_esc_line_separator = predicted <ns esc line separator>\n"
  "event ^ns_esc_paragraph_separator = predicted <ns esc paragraph separator>\n"
  "event ^ns_esc_8_bit = predicted <ns esc 8 bit>\n"
  "event ^ns_esc_16_bit = predicted <ns esc 16 bit>\n"
  "event ^ns_esc_32_bit = predicted <ns esc 32 bit>\n"
  "event ^c_ns_esc_char = predicted <c ns esc char>\n"
  "event ^s_indent = predicted <s indent><--(n)\n"
  "event ^s_indent_less_than = predicted <s indent less than><--(n)\n"
  "event ^s_indent_less_or_equal = predicted <s indent less or equal><--(n)\n"
  "event ^s_separate_in_line = predicted <s separate in line>\n"
  "event ^s_line_prefix = predicted <s line prefix><--(n,c)\n"
  "event ^s_block_line_prefix = predicted <s block line prefix><--(n)\n"
  "event ^s_flow_line_prefix = predicted <s flow line prefix><--(n)\n"
  "event ^l_empty = predicted <l empty><--(n,c)\n"
  "event ^b_l_trimmed = predicted <b l trimmed><--(n,c)\n"
  "event ^b_as_space = predicted <b as space>\n"
  "event ^b_l_folded = predicted <b l folded><--(n,c)\n"
  "event ^s_flow_folded = predicted <s flow folded><--(n)\n"
  "event ^c_nb_comment_text = predicted <c nb comment text>\n"
  "event ^b_comment = predicted <b comment>\n"
  "event ^s_b_comment = predicted <s b comment>\n"
  "event ^l_comment = predicted <l comment>\n"
  "event ^s_l_comments = predicted <s l comments>\n"
  "event ^s_separate = predicted <s separate><--(n,c)\n"
  "event ^s_separate_lines = predicted <s separate lines><--(n)\n"
  "event ^l_directive = predicted <l directive>\n"
  "event ^ns_reserved_directive = predicted <ns reserved directive>\n"
  "event ^ns_directive_name = predicted <ns directive name>\n"
  "event ^ns_directive_parameter = predicted <ns directive parameter>\n"
  "event ^ns_yaml_directive = predicted <ns yaml directive>\n"
  "event ^ns_yaml_version = predicted <ns yaml version>\n"
  "event ^ns_tag_directive = predicted <ns tag directive>\n"
  "event ^c_tag_handle = predicted <c tag handle>\n"
  "event ^c_primary_tag_handle = predicted <c primary tag handle>\n"
  "event ^c_secondary_tag_handle = predicted <c secondary tag handle>\n"
  "event ^c_named_tag_handle = predicted <c named tag handle>\n"
  "event ^ns_tag_prefix = predicted <ns tag prefix>\n"
  "event ^c_ns_local_tag_prefix = predicted <c ns local tag prefix>\n"
  "event ^ns_global_tag_prefix = predicted <ns global tag prefix>\n"
  "event ^c_ns_properties = predicted <c ns properties><--(n,c)\n"
  "event ^c_ns_tag_property = predicted <c ns tag property>\n"
  "event ^c_verbatim_tag = predicted <c verbatim tag>\n"
  "event ^c_ns_shorthand_tag = predicted <c ns shorthand tag>\n"
  "event ^c_non_specific_tag = predicted <c non specific tag>\n"
  "event ^c_ns_anchor_property = predicted <c ns anchor property>\n"
  "event ^ns_anchor_char = predicted <ns anchor char>\n"
  "event ^ns_anchor_name = predicted <ns anchor name>\n"
  "event ^c_ns_alias_node = predicted <c ns alias node>\n"
  "event ^e_scalar = predicted <e scalar>\n"
  "event ^e_node = predicted <e node>\n"
  "event ^nb_double_char = predicted <nb double char>\n"
  "event ^ns_double_char = predicted <ns double char>\n"
  "event ^c_double_quoted = predicted <c double quoted><--(n,c)\n"
  "event ^nb_double_text = predicted <nb double text><--(n,c)\n"
  "event ^nb_double_one_line = predicted <nb double one line>\n"
  "event ^s_double_escaped = predicted <s double escaped><--(n)\n"
  "event ^s_double_break = predicted <s double break><--(n)\n"
  "event ^nb_ns_double_in_line = predicted <nb ns double in line>\n"
  "event ^s_double_next_line = predicted <s double next line><--(n)\n"
  "event ^nb_double_multi_line = predicted <nb double multi line><--(n)\n"
  "event ^c_quoted_quote = predicted <c quoted quote>\n"
  "event ^nb_single_char = predicted <nb single char>\n"
  "event ^ns_single_char = predicted <ns single char>\n"
  "event ^c_single_quote = predicted <c single quote>\n"
  "event ^nb_single_text = predicted <nb single text><--(n,c)\n"
  "event ^nb_single_one_line = predicted <nb single one line>\n"
  "event ^nb_ns_single_in_line = predicted <nb ns single in line>\n"
  "event ^s_single_next_line = predicted <s single next line><--(n)\n"
  "event ^nb_single_multi_line = predicted <nb single multi line><--(n)\n"
  "event ^ns_plain_first = predicted <ns plain first><--(c)\n"
  "event ^ns_plain_safe = predicted <ns plain safe><--(c)\n"
  "event ^ns_plain_safe_out = predicted <ns plain safe out>\n"
  "event ^ns_plain_safe_in = predicted <ns plain safe in>\n"
  "event ^ns_plain_char = predicted <ns plain char><--(c)\n"
  "event ^ns_plain = predicted <ns plain><--(n,c)\n"
  "event ^nb_ns_plain_in_line = predicted <nb ns plain in line><--(c)\n"
  "event ^ns_plain_one_line = predicted <ns plain one line><--(c)\n"
  "event ^s_ns_plain_next_line = predicted <s ns plain next line><--(n,c)\n"
  "event ^in_flow = predicted <in flow><--(n,c)\n"
  "event ^c_flow_sequence = predicted <c flow sequence><--(n,c)\n"
  "event ^ns_s_flow_seq_entries = predicted <ns s flow seq entries><--(n,c)\n"
  "event ^c_flow_mapping = predicted <c flow mapping><--(n,c)\n"
  "event ^ns_s_flow_map_entries = predicted <ns s flow map entries><--(n,c)\n"
  "event ^ns_flow_map_entry = predicted <ns flow map entry><--(n,c)\n"
  "event ^ns_flow_map_explicit_entry = predicted <ns flow map explicit entry><--(n,c)\n"
  "event ^ns_flow_map_implicit_entry = predicted <ns flow map implicit entry><--(n,c)\n"
  "event ^ns_flow_map_yaml_key_entry = predicted <ns flow map yaml key entry><--(n,c)\n"
  "event ^c_ns_flow_map_empty_key_entry = predicted <c ns flow map empty key entry><--(n,c)\n"
  "event ^c_ns_flow_map_separate_value = predicted <c ns flow map separate value><--(n,c)\n"
  "event ^c_ns_flow_map_json_key_entry = predicted <c ns flow map json key entry><--(n,c)\n"
  "event ^c_ns_flow_map_adjacent_value = predicted <c ns flow map adjacent value><--(n,c)\n"
  "event ^ns_flow_pair = predicted <ns flow pair><--(n,c)\n"
  "event ^ns_flow_pair_entry = predicted <ns flow pair entry><--(n,c)\n"
  "event ^ns_flow_pair_yaml_key_entry = predicted <ns flow pair yaml key entry><--(n,c)\n"
  "event ^c_ns_flow_pair_json_key_entry = predicted <c ns flow pair json key entry><--(n,c)\n"
  "event ^ns_s_implicit_yaml_key = predicted <ns s implicit yaml key><--(c)\n"
  "event ^c_s_implicit_json_key = predicted <c s implicit json key><--(c)\n"
  "event ^ns_flow_yaml_content = predicted <ns flow yaml content><--(n,c)\n"
  "event ^c_flow_json_content = predicted <c flow json content><--(n,c)\n"
  "event ^ns_flow_content = predicted <ns flow content><--(n,c)\n"
  "event ^ns_flow_yaml_node = predicted <ns flow yaml node><--(n,c)\n"
  "event ^c_flow_json_node = predicted <c flow json node><--(n,c)\n"
  "event ^ns_flow_node = predicted <ns flow node><--(n,c)\n"
  "event ^c_b_block_header = predicted <c b block header><--(t)\n"
  "event ^c_indentation_indicator = predicted <c indentation indicator>\n"
  "event ^c_chomping_indicator = predicted <c chomping indicator><--(t)\n"
  "event ^b_chomped_last = predicted <b chomped last><--(t)\n"
  "event ^l_chomped_empty = predicted <l chomped empty><--(n,t)\n"
  "event ^l_strip_empty = predicted <l strip empty><--(n)\n"
  "event ^l_keep_empty = predicted <l keep empty><--(n)\n"
  "event ^l_trail_comments = predicted <l trail comments><--(n)\n"
  "event ^c_l_literal = predicted <c l literal><--(n)\n"
  "event ^l_nb_literal_text = predicted <l nb literal text><--(n)\n"
  "event ^b_nb_literal_next = predicted <b nb literal next><--(n)\n"
  "event ^l_literal_content = predicted <l literal content><--(n,t)\n"
  "event ^c_l_folded = predicted <c l folded><--(n)\n"
  "event ^s_nb_folded_text = predicted <s nb folded text><--(n)\n"
  "event ^l_nb_folded_lines = predicted <l nb folded lines><--(n)\n"
  "event ^s_nb_spaced_text = predicted <s nb spaced text><--(n)\n"
  "event ^b_l_spaced = predicted <b l spaced><--(n)\n"
  "event ^l_nb_spaced_lines = predicted <l nb spaced lines><--(n)\n"
  "event ^l_nb_same_lines = predicted <l nb same lines><--(n)\n"
  "event ^l_nb_lines = predicted <l nb diff lines><--(n)\n"
  "event ^l_folded_content = predicted <l folded content><--(n,t)\n"
  "event ^l_block_sequence = predicted <l block sequence><--(n)\n"
  "event ^c_l_block_seq_entry = predicted <c l block seq entry><--(n)\n"
  "event ^s_l_block_indented = predicted <s l block indented><--(n,c)\n"
  "event ^ns_l_compact_sequence = predicted <ns l compact sequence><--(n)\n"
  "event ^l_block_mapping = predicted <l block mapping><--(n)\n"
  "event ^ns_l_block_map_entry = predicted <ns l block map entry><--(n)\n"
  "event ^c_l_block_map_explicit_entry = predicted <c l block map explicit entry><--(n)\n"
  "event ^c_l_block_map_explicit_key = predicted <c l block map explicit key><--(n)\n"
  "event ^l_block_map_explicit_value = predicted <l block map explicit value><--(n)\n"
  "event ^ns_l_block_map_implicit_entry = predicted <ns l block map implicit entry><--(n)\n"
  "event ^ns_s_block_map_implicit_key = predicted <ns s block map implicit key>\n"
  "event ^c_l_block_map_implicit_value = predicted <c l block map implicit value><--(n)\n"
  "event ^ns_l_compact_mapping = predicted <ns l compact mapping><--(n)\n"
  "event ^s_l_block_node = predicted <s l block node><--(n,c)\n"
  "event ^s_l_flow_in_block = predicted <s l flow in block><--(n)\n"
  "event ^s_l_block_in_block = predicted <s l block in block><--(n,c)\n"
  "event ^s_l_block_scalar = predicted <s l block scalar><--(n,c)\n"
  "event ^s_l_block_collection = predicted <s l block collection><--(n,c)\n"
  "event ^seq_space = predicted <seq space><--(n,c)\n"
  "event ^l_document_prefix = predicted <l document prefix>\n"
  "event ^c_directives_end = predicted <c directives end>\n"
  "event ^c_document_end = predicted <c document end>\n"
  "event ^l_document_suffix = predicted <l document suffix>\n"
  "event ^c_forbidden = predicted <c forbidden>\n"
  "event ^l_bare_document = predicted <l bare document>\n"
  "event ^l_explicit_document = predicted <l explicit document>\n"
  "event ^l_directive_document = predicted <l directive document>\n"
  "event ^l_yaml_stream = predicted <l yaml stream>\n"
  
  "event start_of_line$ = completed <start of line>\n"
  "event end_of_input$ = completed <end of input>\n"
  "event empty$ = completed <empty>\n"
  "event c_printable$ = completed <c printable>\n"
  "event nb_json$ = completed <nb json>\n"
  "event c_byte_order_mark$ = completed <c byte order mark>\n"
  "event c_sequence_entry$ = completed <c sequence entry>\n"
  "event c_mapping_key$ = completed <c mapping key>\n"
  "event c_mapping_value$ = completed <c mapping value>\n"
  "event c_collect_entry$ = completed <c collect entry>\n"
  "event c_sequence_start$ = completed <c sequence start>\n"
  "event c_sequence_end$ = completed <c sequence end>\n"
  "event c_mapping_start$ = completed <c mapping start>\n"
  "event c_mapping_end$ = completed <c mapping end>\n"
  "event c_comment$ = completed <c comment>\n"
  "event c_anchor$ = completed <c anchor>\n"
  "event c_alias$ = completed <c alias>\n"
  "event c_tag$ = completed <c tag>\n"
  "event c_literal$ = completed <c literal>\n"
  "event c_folded$ = completed <c folded>\n"
  "event c_single_quote$ = completed <c single quote>\n"
  "event c_double_quote$ = completed <c double quote>\n"
  "event c_directive$ = completed <c directive>\n"
  "event c_reserved$ = completed <c reserved>\n"
  "event c_indicator$ = completed <c indicator>\n"
  "event c_flow_indicator$ = completed <c flow indicator>\n"
  "event b_line_feed$ = completed <b line feed>\n"
  "event b_carriage_return$ = completed <b carriage return>\n"
  "event b_char$ = completed <b char>\n"
  "event nb_char$ = completed <nb char>\n"
  "event b_break$ = completed <b break>\n"
  "event b_as_line_feed$ = completed <b as line feed>\n"
  "event b_non_content$ = completed <b non content>\n"
  "event s_space$ = completed <s space>\n"
  "event s_tab$ = completed <s tab>\n"
  "event s_white$ = completed <s white>\n"
  "event ns_char$ = completed <ns char>\n"
  "event ns_dec_digit$ = completed <ns dec digit>\n"
  "event ns_hex_digit$ = completed <ns hex digit>\n"
  "event ns_ascii_letter$ = completed <ns ascii letter>\n"
  "event ns_word_char$ = completed <ns word char>\n"
  "event ns_uri_char$ = completed <ns uri char>\n"
  "event ns_tag_char$ = completed <ns tag char>\n"
  "event c_escape$ = completed <c escape>\n"
  "event ns_esc_null$ = completed <ns esc null>\n"
  "event ns_esc_bell$ = completed <ns esc bell>\n"
  "event ns_esc_backspace$ = completed <ns esc backspace>\n"
  "event ns_esc_horizontal_tab$ = completed <ns esc horizontal tab>\n"
  "event ns_esc_line_feed$ = completed <ns esc line feed>\n"
  "event ns_esc_vertical_tab$ = completed <ns esc vertical tab>\n"
  "event ns_esc_form_feed$ = completed <ns esc form feed>\n"
  "event ns_esc_carriage_return$ = completed <ns esc carriage return>\n"
  "event ns_esc_escape$ = completed <ns esc escape>\n"
  "event ns_esc_double_quote$ = completed <ns esc double quote>\n"
  "event ns_esc_slash$ = completed <ns esc slash>\n"
  "event ns_esc_backslash$ = completed <ns esc backslash>\n"
  "event ns_esc_next_line$ = completed <ns esc next line>\n"
  "event ns_esc_non_breaking_space$ = completed <ns esc non breaking space>\n"
  "event ns_esc_line_separator$ = completed <ns esc line separator>\n"
  "event ns_esc_paragraph_separator$ = completed <ns esc paragraph separator>\n"
  "event ns_esc_8_bit$ = completed <ns esc 8 bit>\n"
  "event ns_esc_16_bit$ = completed <ns esc 16 bit>\n"
  "event ns_esc_32_bit$ = completed <ns esc 32 bit>\n"
  "event c_ns_esc_char$ = completed <c ns esc char>\n"
  "event s_indent$ = completed <s indent><--(n)\n"
  "event s_indent_less_than$ = completed <s indent less than><--(n)\n"
  "event s_indent_less_or_equal$ = completed <s indent less or equal><--(n)\n"
  "event s_separate_in_line$ = completed <s separate in line>\n"
  "event s_line_prefix$ = completed <s line prefix><--(n,c)\n"
  "event s_block_line_prefix$ = completed <s block line prefix><--(n)\n"
  "event s_flow_line_prefix$ = completed <s flow line prefix><--(n)\n"
  "event l_empty$ = completed <l empty><--(n,c)\n"
  "event b_l_trimmed$ = completed <b l trimmed><--(n,c)\n"
  "event b_as_space$ = completed <b as space>\n"
  "event b_l_folded$ = completed <b l folded><--(n,c)\n"
  "event s_flow_folded$ = completed <s flow folded><--(n)\n"
  "event c_nb_comment_text$ = completed <c nb comment text>\n"
  "event b_comment$ = completed <b comment>\n"
  "event s_b_comment$ = completed <s b comment>\n"
  "event l_comment$ = completed <l comment>\n"
  "event s_l_comments$ = completed <s l comments>\n"
  "event s_separate$ = completed <s separate><--(n,c)\n"
  "event s_separate_lines$ = completed <s separate lines><--(n)\n"
  "event l_directive$ = completed <l directive>\n"
  "event ns_reserved_directive$ = completed <ns reserved directive>\n"
  "event ns_directive_name$ = completed <ns directive name>\n"
  "event ns_directive_parameter$ = completed <ns directive parameter>\n"
  "event ns_yaml_directive$ = completed <ns yaml directive>\n"
  "event ns_yaml_version$ = completed <ns yaml version>\n"
  "event ns_tag_directive$ = completed <ns tag directive>\n"
  "event c_tag_handle$ = completed <c tag handle>\n"
  "event c_primary_tag_handle$ = completed <c primary tag handle>\n"
  "event c_secondary_tag_handle$ = completed <c secondary tag handle>\n"
  "event c_named_tag_handle$ = completed <c named tag handle>\n"
  "event ns_tag_prefix$ = completed <ns tag prefix>\n"
  "event c_ns_local_tag_prefix$ = completed <c ns local tag prefix>\n"
  "event ns_global_tag_prefix$ = completed <ns global tag prefix>\n"
  "event c_ns_properties$ = completed <c ns properties><--(n,c)\n"
  "event c_ns_tag_property$ = completed <c ns tag property>\n"
  "event c_verbatim_tag$ = completed <c verbatim tag>\n"
  "event c_ns_shorthand_tag$ = completed <c ns shorthand tag>\n"
  "event c_non_specific_tag$ = completed <c non specific tag>\n"
  "event c_ns_anchor_property$ = completed <c ns anchor property>\n"
  "event ns_anchor_char$ = completed <ns anchor char>\n"
  "event ns_anchor_name$ = completed <ns anchor name>\n"
  "event c_ns_alias_node$ = completed <c ns alias node>\n"
  "event e_scalar$ = completed <e scalar>\n"
  "event e_node$ = completed <e node>\n"
  "event nb_double_char$ = completed <nb double char>\n"
  "event ns_double_char$ = completed <ns double char>\n"
  "event c_double_quoted$ = completed <c double quoted><--(n,c)\n"
  "event nb_double_text$ = completed <nb double text><--(n,c)\n"
  "event nb_double_one_line$ = completed <nb double one line>\n"
  "event s_double_escaped$ = completed <s double escaped><--(n)\n"
  "event s_double_break$ = completed <s double break><--(n)\n"
  "event nb_ns_double_in_line$ = completed <nb ns double in line>\n"
  "event s_double_next_line$ = completed <s double next line><--(n)\n"
  "event nb_double_multi_line$ = completed <nb double multi line><--(n)\n"
  "event c_quoted_quote$ = completed <c quoted quote>\n"
  "event nb_single_char$ = completed <nb single char>\n"
  "event ns_single_char$ = completed <ns single char>\n"
  "event c_single_quote$ = completed <c single quote>\n"
  "event nb_single_text$ = completed <nb single text><--(n,c)\n"
  "event nb_single_one_line$ = completed <nb single one line>\n"
  "event nb_ns_single_in_line$ = completed <nb ns single in line>\n"
  "event s_single_next_line$ = completed <s single next line><--(n)\n"
  "event nb_single_multi_line$ = completed <nb single multi line><--(n)\n"
  "event ns_plain_first$ = completed <ns plain first><--(c)\n"
  "event ns_plain_safe$ = completed <ns plain safe><--(c)\n"
  "event ns_plain_safe_out$ = completed <ns plain safe out>\n"
  "event ns_plain_safe_in$ = completed <ns plain safe in>\n"
  "event ns_plain_char$ = completed <ns plain char><--(c)\n"
  "event ns_plain$ = completed <ns plain><--(n,c)\n"
  "event nb_ns_plain_in_line$ = completed <nb ns plain in line><--(c)\n"
  "event ns_plain_one_line$ = completed <ns plain one line><--(c)\n"
  "event s_ns_plain_next_line$ = completed <s ns plain next line><--(n,c)\n"
  "event in_flow$ = completed <in flow><--(n,c)\n"
  "event c_flow_sequence$ = completed <c flow sequence><--(n,c)\n"
  "event ns_s_flow_seq_entries$ = completed <ns s flow seq entries><--(n,c)\n"
  "event c_flow_mapping$ = completed <c flow mapping><--(n,c)\n"
  "event ns_s_flow_map_entries$ = completed <ns s flow map entries><--(n,c)\n"
  "event ns_flow_map_entry$ = completed <ns flow map entry><--(n,c)\n"
  "event ns_flow_map_explicit_entry$ = completed <ns flow map explicit entry><--(n,c)\n"
  "event ns_flow_map_implicit_entry$ = completed <ns flow map implicit entry><--(n,c)\n"
  "event ns_flow_map_yaml_key_entry$ = completed <ns flow map yaml key entry><--(n,c)\n"
  "event c_ns_flow_map_empty_key_entry$ = completed <c ns flow map empty key entry><--(n,c)\n"
  "event c_ns_flow_map_separate_value$ = completed <c ns flow map separate value><--(n,c)\n"
  "event c_ns_flow_map_json_key_entry$ = completed <c ns flow map json key entry><--(n,c)\n"
  "event c_ns_flow_map_adjacent_value$ = completed <c ns flow map adjacent value><--(n,c)\n"
  "event ns_flow_pair$ = completed <ns flow pair><--(n,c)\n"
  "event ns_flow_pair_entry$ = completed <ns flow pair entry><--(n,c)\n"
  "event ns_flow_pair_yaml_key_entry$ = completed <ns flow pair yaml key entry><--(n,c)\n"
  "event c_ns_flow_pair_json_key_entry$ = completed <c ns flow pair json key entry><--(n,c)\n"
  "event ns_s_implicit_yaml_key$ = completed <ns s implicit yaml key><--(c)\n"
  "event c_s_implicit_json_key$ = completed <c s implicit json key><--(c)\n"
  "event ns_flow_yaml_content$ = completed <ns flow yaml content><--(n,c)\n"
  "event c_flow_json_content$ = completed <c flow json content><--(n,c)\n"
  "event ns_flow_content$ = completed <ns flow content><--(n,c)\n"
  "event ns_flow_yaml_node$ = completed <ns flow yaml node><--(n,c)\n"
  "event c_flow_json_node$ = completed <c flow json node><--(n,c)\n"
  "event ns_flow_node$ = completed <ns flow node><--(n,c)\n"
  "event c_b_block_header$ = completed <c b block header><--(t)\n"
  "event c_indentation_indicator$ = completed <c indentation indicator>\n"
  "event c_chomping_indicator$ = completed <c chomping indicator><--(t)\n"
  "event b_chomped_last$ = completed <b chomped last><--(t)\n"
  "event l_chomped_empty$ = completed <l chomped empty><--(n,t)\n"
  "event l_strip_empty$ = completed <l strip empty><--(n)\n"
  "event l_keep_empty$ = completed <l keep empty><--(n)\n"
  "event l_trail_comments$ = completed <l trail comments><--(n)\n"
  "event c_l_literal$ = completed <c l literal><--(n)\n"
  "event l_nb_literal_text$ = completed <l nb literal text><--(n)\n"
  "event b_nb_literal_next$ = completed <b nb literal next><--(n)\n"
  "event l_literal_content$ = completed <l literal content><--(n,t)\n"
  "event c_l_folded$ = completed <c l folded><--(n)\n"
  "event s_nb_folded_text$ = completed <s nb folded text><--(n)\n"
  "event l_nb_folded_lines$ = completed <l nb folded lines><--(n)\n"
  "event s_nb_spaced_text$ = completed <s nb spaced text><--(n)\n"
  "event b_l_spaced$ = completed <b l spaced><--(n)\n"
  "event l_nb_spaced_lines$ = completed <l nb spaced lines><--(n)\n"
  "event l_nb_same_lines$ = completed <l nb same lines><--(n)\n"
  "event l_nb_lines$ = completed <l nb diff lines><--(n)\n"
  "event l_folded_content$ = completed <l folded content><--(n,t)\n"
  "event l_block_sequence$ = completed <l block sequence><--(n)\n"
  "event c_l_block_seq_entry$ = completed <c l block seq entry><--(n)\n"
  "event s_l_block_indented$ = completed <s l block indented><--(n,c)\n"
  "event ns_l_compact_sequence$ = completed <ns l compact sequence><--(n)\n"
  "event l_block_mapping$ = completed <l block mapping><--(n)\n"
  "event ns_l_block_map_entry$ = completed <ns l block map entry><--(n)\n"
  "event c_l_block_map_explicit_entry$ = completed <c l block map explicit entry><--(n)\n"
  "event c_l_block_map_explicit_key$ = completed <c l block map explicit key><--(n)\n"
  "event l_block_map_explicit_value$ = completed <l block map explicit value><--(n)\n"
  "event ns_l_block_map_implicit_entry$ = completed <ns l block map implicit entry><--(n)\n"
  "event ns_s_block_map_implicit_key$ = completed <ns s block map implicit key>\n"
  "event c_l_block_map_implicit_value$ = completed <c l block map implicit value><--(n)\n"
  "event ns_l_compact_mapping$ = completed <ns l compact mapping><--(n)\n"
  "event s_l_block_node$ = completed <s l block node><--(n,c)\n"
  "event s_l_flow_in_block$ = completed <s l flow in block><--(n)\n"
  "event s_l_block_in_block$ = completed <s l block in block><--(n,c)\n"
  "event s_l_block_scalar$ = completed <s l block scalar><--(n,c)\n"
  "event s_l_block_collection$ = completed <s l block collection><--(n,c)\n"
  "event seq_space$ = completed <seq space><--(n,c)\n"
  "event l_document_prefix$ = completed <l document prefix>\n"
  "event c_directives_end$ = completed <c directives end>\n"
  "event c_document_end$ = completed <c document end>\n"
  "event l_document_suffix$ = completed <l document suffix>\n"
  "event c_forbidden$ = completed <c forbidden>\n"
  "event l_bare_document$ = completed <l bare document>\n"
  "event l_explicit_document$ = completed <l explicit document>\n"
  "event l_directive_document$ = completed <l directive document>\n"
  "event l_yaml_stream$ = completed <l yaml stream>\n"
  
  "#\n"
  "# Reference: https://yaml.org/spec/1.2.2/\n"
  "#\n"
  ":default ::= fallback-encoding => UTF-8 event-action => ::luac->function(events)\n"
  "                                                                  print('======================================')\n"
  "                                                                  marpaESLIFRecognizer:progressLog(-1,-1,GENERICLOGGER_LOGLEVEL_NOTICE)\n"
  "                                                                  local _tojoin = {}\n"
  "                                                                  local _n,_m\n"
  "                                                                  for _n,_m in pairs(events) do\n"
  "                                                                    local _e = _m['event']\n"
  "                                                                    _tojoin[#_tojoin + 1] = _e\n"
  "                                                                    ----------------------------\n"
  "                                                                    if (_e == 's_indent[]') then\n"
  "                                                                      local n = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (n <= 0) then\n"
  "                                                                        print(_e..': .... JDD alternative S_INDENT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('S_INDENT', nil, 0)\n"
  "                                                                      else\n"
  "                                                                        local match = marpaESLIFRecognizer:symbolTry(re_spaces)\n"
  "                                                                        if match ~= nil and match == n then\n"
  "                                                                        print(_e..': .... JDD alternative S_INDENT '..n)\n"
  "                                                                          marpaESLIFRecognizer:alternativeRead('S_INDENT', nil, n)\n"
  "                                                                        end\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 's_indent_less_than[]') then\n"
  "                                                                      local n = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (n <= 1) then\n"
  "                                                                        print(_e..': .... JDD alternative S_INDENT_LESS_THAN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('S_INDENT_LESS_THAN', nil, 0)\n"
  "                                                                      else\n"
  "                                                                        local match = marpaESLIFRecognizer:symbolTry(re_spaces)\n"
  "                                                                        if match ~= nil and match < n then\n"
  "                                                                          print(_e..': .... JDD alternative S_INDENT_LESS_THAN '..n)\n"
  "                                                                          marpaESLIFRecognizer:alternativeRead('S_INDENT_LESS_THAN', nil, n)\n"
  "                                                                        else\n"
  "                                                                          print(_e..': .... JDD alternative S_INDENT_LESS_THAN 0')\n"
  "                                                                          marpaESLIFRecognizer:alternativeRead('S_INDENT_LESS_THAN', nil, 0)\n"
  "                                                                        end\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 's_indent_less_or_equal[]') then\n"
  "                                                                      local n = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (n <= 0) then\n"
  "                                                                        print(_e..': .... JDD alternative S_INDENT_LESS_OR_EQUAL 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('S_INDENT_LESS_OR_EQUAL', nil, 0)\n"
  "                                                                      else\n"
  "                                                                        local match = marpaESLIFRecognizer:symbolTry(re_spaces)\n"
  "                                                                        if match ~= nil and match <= n then\n"
  "                                                                          print(_e..': .... JDD alternative S_INDENT_LESS_OR_EQUAL '..n)\n"
  "                                                                          marpaESLIFRecognizer:alternativeRead('S_INDENT_LESS_OR_EQUAL', nil, n)\n"
  "                                                                        else\n"
  "                                                                          print(_e..': .... JDD alternative S_INDENT_LESS_OR_EQUAL 0')\n"
  "                                                                          marpaESLIFRecognizer:alternativeRead('S_INDENT_LESS_OR_EQUAL', nil, 0)\n"
  "                                                                        end\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 's_line_prefix[]') then\n"
  "                                                                      local n,c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'BLOCK-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_IN', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_IN', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 's_separate[]') then\n"
  "                                                                      local n,c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'BLOCK-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_IN', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_IN', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_KEY', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_KEY', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'nb_double_text[]') then\n"
  "                                                                      local n,c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'FLOW-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_IN', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_KEY', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_KEY', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'nb_single_text[]') then\n"
  "                                                                      local n,c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'FLOW-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_IN', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_KEY', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_KEY', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'ns_plain_safe[]') then\n"
  "                                                                      local c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'FLOW-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_IN', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_KEY', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_KEY', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'ns_plain[]') then\n"
  "                                                                      local n,c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'FLOW-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_IN', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_KEY', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_KEY', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'in_flow[]') then\n"
  "                                                                      local n,c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'FLOW-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_IN', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_KEY', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_KEY', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'c_chomping_indicator[]') then\n"
  "                                                                      local t = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (t == 'STRIP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_STRIP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_STRIP', nil, 0)\n"
  "                                                                      elseif (t == 'KEEP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_KEEP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_KEEP', nil, 0)\n"
  "                                                                      elseif (t == 'CLIP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_CLIP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_CLIP', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'b_chomped_last[]') then\n"
  "                                                                      local t = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (t == 'STRIP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_STRIP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_STRIP', nil, 0)\n"
  "                                                                      elseif (t == 'KEEP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_KEEP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_KEEP', nil, 0)\n"
  "                                                                      elseif (t == 'CLIP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_CLIP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_CLIP', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'l_chomped_empty[]') then\n"
  "                                                                      local n,t = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (t == 'STRIP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_STRIP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_STRIP', nil, 0)\n"
  "                                                                      elseif (t == 'KEEP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_KEEP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_KEEP', nil, 0)\n"
  "                                                                      elseif (t == 'CLIP') then\n"
  "                                                                        print(_e..': .... JDD alternative T_IS_CLIP 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('T_IS_CLIP', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'seq_space[]') then\n"
  "                                                                      local n,c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'BLOCK-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_OUT', nil, 0)\n"
  "                                                                      elseif (t == 'BLOCK-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_IN', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'ns_plain_safe_minus_c_mapping_value_and_c_comment[]') then\n"
  "                                                                      local c = table.unpack(marpaESLIFContextStackp:get())\n"
  "                                                                      if (c == 'FLOW-OUT') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_OUT 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_OUT', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-IN') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_IN 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_IN', nil, 0)\n"
  "                                                                      elseif (c == 'BLOCK-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_BLOCK_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_BLOCK_KEY', nil, 0)\n"
  "                                                                      elseif (c == 'FLOW-KEY') then\n"
  "                                                                        print(_e..': .... JDD alternative C_IS_FLOW_KEY 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('C_IS_FLOW_KEY', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'start_of_line$') then\n"
  "                                                                      -- If this is truely a start of line, we want get the auto detected m\n"
  "                                                                      local match = marpaESLIFRecognizer:symbolTry(re_spaces)\n"
  "                                                                      print(_e..': .... JDD match=\"'..tostring(match)..'\"')\n"
  "                                                                      if (match == nil) then\n"
  "                                                                        auto_m = 0\n"
  "                                                                      else\n"
  "                                                                        auto_m = match:len()\n"
  "                                                                      end\n"
  "                                                                      print(_e..': .... JDD auto_m='..auto_m)\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'l_block_mapping[]') then\n"
  "                                                                      if (auto_m > 0) then\n"
  "                                                                        -- m is set to auto_m\n"
  "                                                                        m = auto_m\n"
  "                                                                        print(_e..': .... JDD alternative M_IS_GREATER_THAN_ZERO 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('M_IS_GREATER_THAN_ZERO', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    ----------------------------\n"
  "                                                                    elseif (_e == 'l_block_sequence[]') then\n"
  "                                                                      if (auto_m > 0) then\n"
  "                                                                        -- m is set to auto_m\n"
  "                                                                        m = auto_m\n"
  "                                                                        print(_e..': .... JDD alternative M_IS_GREATER_THAN_ZERO 0')\n"
  "                                                                        marpaESLIFRecognizer:alternativeRead('M_IS_GREATER_THAN_ZERO', nil, 0)\n"
  "                                                                      end\n"
  "                                                                    end\n"
  "                                                                  end\n"
  "                                                                  print('Input['..marpaESLIFRecognizer:line()..','..marpaESLIFRecognizer:column()..']: <'..(tostring(marpaESLIFRecognizer:input(0,10)) or '          ')..'> Events: '..table.concat(_tojoin, ' '))\n"
  "                                                                  return true\n"
  "                                                                end\n"
  ":start   ::= <l yaml stream>\n"
  ":desc    ::= 'YAML'\n"
  "\n"
  "\n"
  "#\n"
  "# Special productions\n"
  "#\n"
  ":symbol ::= :sol priority => -1\n"
  ":symbol ::= :eof priority => -1\n"
  ":symbol ::= :empty priority => -1\n"
  "<start of line> ::= :sol\n"
  "<end of input>  ::= :eof\n"
  "<empty>         ::= :empty\n"
  "\n"
  "\n"
  "/* [1] */ <c printable> ::=\n"
  "                              # 8 bit\n"
  "    [\\x{09}]                  # Tab (\\t)\n"
  "  | [\\x{0A}]                  # Line feed (LF \\n)\n"
  "  | [\\x{0D}]                  # Carriage Return (CR \\r)\n"
  "  | [\\x{20}-\\x{7E}]           # Printable ASCII\n"
  "                              # 16 bit\n"
  "  | [\\x{85}]                  # Next Line (NEL)\n"
  "  | [\\x{A0}-\\x{D7FF}]:u       # Basic Multilingual Plane (BMP)\n"
  "  | [\\x{E000}-\\x{FFFD}]:u     # Additional Unicode Areas\n"
  "  | [\\x{010000}-\\x{10FFFF}]:u # 32 bit\n"
  "\n"
  "/* [2] */ <nb json> ::=\n"
  "    [\\x{09}]                  # Tab character\n"
  "  | [\\x{20}-\\x{10FFFF}]:u     # Non-C0-control characters\n"
  "\n"
  "/* [3] */ <c byte order mark> ::= [\\x{FEFF}]:u\n"
  "/* [4] */ <c sequence entry>  ::= '-'\n"
  "/* [5] */ <c mapping key>     ::= '?'\n"
  "/* [6] */ <c mapping value>   ::= ':'\n"
  "/* [7] */ <c collect entry>   ::= ','\n"
  "/* [8] */ <c sequence start>  ::= '['\n"
  "/* [9] */ <c sequence end>    ::= ']'\n"
  "/* [10] */ <c mapping start>  ::= '{'\n"
  "/* [11] */ <c mapping end>    ::= '}'\n"
  "/* [12] */ <c comment>        ::= '#'\n"
  "/* [13] */ <c anchor>         ::= '&'\n"
  "/* [14] */ <c alias>          ::= '*'\n"
  "/* [15] */ <c tag>            ::= '!'\n"
  "/* [16] */ <c literal>        ::= '|'\n"
  "/* [17] */ <c folded>         ::= '>'\n"
  "/* [18] */ <c single quote>   ::= \"'\"\n"
  "/* [19] */ <c double quote>   ::= '\"'\n"
  "/* [20] */ <c directive>      ::= '%'\n"
  "/* [21] */ <c reserved>       ::= '@' | '`'\n"
  "/* [22] */ <c indicator>      ::=\n"
  "    <c sequence entry>    # '-'\n"
  "  | <c mapping key>       # '?'\n"
  "  | <c mapping value>     # ':'\n"
  "  | <c collect entry>     # ','\n"
  "  | <c sequence start>    # '['\n"
  "  | <c sequence end>      # ']'\n"
  "  | <c mapping start>     # '{'\n"
  "  | <c mapping end>       # '}'\n"
  "  | <c comment>           # '#'\n"
  "  | <c anchor>            # '&'\n"
  "  | <c alias>             # '*'\n"
  "  | <c tag>               # '!'\n"
  "  | <c literal>           # '|'\n"
  "  | <c folded>            # '>'\n"
  "  | <c single quote>      # \"'\"\n"
  "  | <c double quote>      # '\"'\n"
  "  | <c directive>         # '%'\n"
  "  | <c reserved>          # '@' '`'\n"
  "/* [23] */ <c flow indicator> ::=\n"
  "    <c collect entry>     # ','\n"
  "  | <c sequence start>    # '['\n"
  "  | <c sequence end>      # ']'\n"
  "  | <c mapping start>     # '{'\n"
  "  | <c mapping end>       # '}'\n"
  "/* [24] */ <b line feed> ::= [\\x{0A}]\n"
  "/* [25] */ <b carriage return> ::= [\\x{0D}]\n"
  "/* [26] */ <b char> ::=\n"
  "    <b line feed>          # x0A\n"
  "  | <b carriage return>    # x0D\n"
  "/* [27] */ <nb char> ::=      /* <c printable> - ( <b char> | <c byte order mark> ) */\n"
  "                              # 8 bit\n"
  "    [\\x{09}]                  # Tab (\\t)\n"
  "  | [\\x{20}-\\x{7E}]           # Printable ASCII\n"
  "                              # 16 bit\n"
  "  | [\\x{85}]                  # Next Line (NEL)\n"
  "  | [\\x{A0}-\\x{D7FF}]:u       # Basic Multilingual Plane (BMP)\n"
  "  | [\\x{E000}-\\x{FEFE}\\x{FF00}-\\x{FFFD}]:u     # Additional Unicode Areas minus 0xFEFF\n"
  "  | [\\x{010000}-\\x{10FFFF}]:u # 32 bit\n"
  "/* [28] */ <b break> ::=\n"
  "    <b carriage return>  # x0A\n"
  "    <b line feed>        # x0D\n"
  "  | <b carriage return>\n"
  "  | <b line feed>\n"
  "/* [29] */ <b as line feed> ::=\n"
  "  <b break>\n"
  "/* [30] */ <b non content> ::=\n"
  "  <b break>\n"
  "/* [31] */ <s space> ::= [\\x{20}]\n"
  "/* [32] */ <s tab> ::= [\\x{09}]\n"
  "/* [33] */ <s white> ::=\n"
  "    <s space>\n"
  "  | <s tab>\n"
  "/* [34] */ <ns char> ::= /* <nb char> - <s white> */\n"
  "                              # 8 bit\n"
  "   [\\x{21}-\\x{7E}]           # Printable ASCII minus <s space>\n"
  "                              # 16 bit\n"
  "  | [\\x{85}]                  # Next Line (NEL)\n"
  "  | [\\x{A0}-\\x{D7FF}]:u       # Basic Multilingual Plane (BMP)\n"
  "  | [\\x{E000}-\\x{FEFE}\\x{FF00}-\\x{FFFD}]:u     # Additional Unicode Areas minus 0xFEFF\n"
  "  | [\\x{010000}-\\x{10FFFF}]:u # 32 bit\n"
  "/* [35] */ <ns dec digit> ::=\n"
  "  [\\x{30}-\\x{39}]             # 0-9\n"
  "/* [36] */ <ns hex digit> ::=\n"
  "    <ns dec digit>        # 0-9\n"
  "  | [\\x{41}-\\x{46}]           # A-F\n"
  "  | [\\x{61}-\\x{66}]           # a-f\n"
  "/* [37] */ <ns ascii letter> ::=\n"
  "    [\\x{41}-\\x{5A}]           # A-Z\n"
  "  | [\\x{61}-\\x{7A}]           # a-z\n"
  "/* [38] */ <ns word char> ::=\n"
  "    <ns dec digit>        # 0-9\n"
  "  | <ns ascii letter>     # A-Z a-z\n"
  "  | '-'                 # '-'\n"
  "/* [39] */ <ns uri char> ::=\n"
  "    '%' <ns hex digit> <ns hex digit>\n"
  "  | <ns word char>\n"
  "  | '#'\n"
  "  | ';'\n"
  "  | '/'\n"
  "  | '?'\n"
  "  | ':'\n"
  "  | '@'\n"
  "  | '&'\n"
  "  | '='\n"
  "  | '+'\n"
  "  | '$'\n"
  "  | ','\n"
  "  | '_'\n"
  "  | '.'\n"
  "  | '!'\n"
  "  | '~'\n"
  "  | '*'\n"
  "  | \"'\"\n"
  "  | '('\n"
  "  | ')'\n"
  "  | '['\n"
  "  | ']'\n"
  "/* [40] */ <ns tag char> ::= /* <ns uri char> - <c tag> - <c flow indicator> */\n"
  "    '%' <ns hex digit> <ns hex digit>\n"
  "  | <ns word char>\n"
  "  | '#'\n"
  "  | ';'\n"
  "  | '/'\n"
  "  | '?'\n"
  "  | ':'\n"
  "  | '@'\n"
  "  | '&'\n"
  "  | '='\n"
  "  | '+'\n"
  "  | '$'\n"
  "  | '_'\n"
  "  | '.'\n"
  "  | '~'\n"
  "  | '*'\n"
  "  | \"'\"\n"
  "  | '('\n"
  "  | ')'\n"
  "/* [41] */ <c escape> ::= '\\\\'\n"
  "/* [42] */ <ns esc null> ::= '0'\n"
  "/* [43] */ <ns esc bell> ::= 'a'\n"
  "/* [44] */ <ns esc backspace> ::= 'b'\n"
  "/* [45] */ <ns esc horizontal tab> ::=\n"
  "    't'\n"
  "  | [\\x{09}]\n"
  "/* [46] */ <ns esc line feed> ::= 'n'\n"
  "/* [47] */ <ns esc vertical tab> ::= 'v'\n"
  "/* [48] */ <ns esc form feed> ::= 'f'\n"
  "/* [49] */ <ns esc carriage return> ::= 'r'\n"
  "/* [50] */ <ns esc escape> ::= 'e'\n"
  "/* [51] */ <ns esc space> ::= [\\x{20}]\n"
  "/* [52] */ <ns esc double quote> ::= '\"'\n"
  "/* [53] */ <ns esc slash> ::= '/'\n"
  "/* [54] */ <ns esc backslash> ::= '\\\\'\n"
  "/* [55] */ <ns esc next line> ::= 'N'\n"
  "/* [56] */ <ns esc non breaking space> ::= '_'\n"
  "/* [57] */ <ns esc line separator> ::= 'L'\n"
  "/* [58] */ <ns esc paragraph separator> ::= 'P'\n"
  "/* [59] */ <ns esc 8 bit> ::=\n"
  "  'x' <ns hex digit> <ns hex digit>\n"
  "/* [60] */ <ns esc 16 bit> ::=\n"
  "  'u' <ns hex digit> <ns hex digit> <ns hex digit> <ns hex digit>\n"
  "/* [61] */ <ns esc 32 bit> ::=\n"
  "  'U' <ns hex digit> <ns hex digit> <ns hex digit> <ns hex digit> <ns hex digit> <ns hex digit> <ns hex digit> <ns hex digit>\n"
  "/* [62] */ <c ns esc char> ::=\n"
  "  <c escape>         # '\\'\n"
  "  (\n"
  "      <ns esc null>\n"
  "    | <ns esc bell>\n"
  "    | <ns esc backspace>\n"
  "    | <ns esc horizontal tab>\n"
  "    | <ns esc line feed>\n"
  "    | <ns esc vertical tab>\n"
  "    | <ns esc form feed>\n"
  "    | <ns esc carriage return>\n"
  "    | <ns esc escape>\n"
  "    | <ns esc space>\n"
  "    | <ns esc double quote>\n"
  "    | <ns esc slash>\n"
  "    | <ns esc backslash>\n"
  "    | <ns esc next line>\n"
  "    | <ns esc non breaking space>\n"
  "    | <ns esc line separator>\n"
  "    | <ns esc paragraph separator>\n"
  "    | <ns esc 8 bit>\n"
  "    | <ns esc 16 bit>\n"
  "    | <ns esc 32 bit>\n"
  "  )\n"
  "\n"
  " S_INDENT ~ [^\\s\\S]\n"
  "event s_indent[] = nulled <marker s indent>\n"
  "<marker s indent> ::=\n"
  "<s indent><--(n) ::= <marker s indent> S_INDENT\n"

  " S_INDENT_LESS_THAN ~ [^\\s\\S]\n"
  "event s_indent_less_than[] = nulled <marker s indent less than>\n"
  "<marker s indent less than> ::=\n"
  "<s indent less than><--(n) ::= <marker s indent less than> S_INDENT_LESS_THAN\n"

  " S_INDENT_LESS_OR_EQUAL ~ [^\\s\\S]\n"
  "event s_indent_or_equal[] = nulled <marker s indent less or equal>\n"
  "<marker s indent less or equal> ::=\n"
  "<s indent less or equal><--(n) ::= <marker s indent less or equal> S_INDENT_LESS_OR_EQUAL\n"

  "/* [66] */ <s separate in line> ::=\n"
  "    ( <s white> +)\n"
  "  | <start of line>\n"
  "\n"

  " C_IS_BLOCK_OUT ~ [^\\s\\S]\n"
  " C_IS_BLOCK_IN  ~ [^\\s\\S]\n"
  " C_IS_FLOW_OUT  ~ [^\\s\\S]\n"
  " C_IS_FLOW_IN   ~ [^\\s\\S]\n"
  "<marker s line prefix> ::=\n"
  "event s_line_prefix[] = nulled <marker s line prefix>\n"
  "<s line prefix><--(n,c) ::= <marker s line prefix> C_IS_BLOCK_OUT <s block line prefix>-->(n)\n"
  "                          | <marker s line prefix> C_IS_BLOCK_IN  <s block line prefix>-->(n)\n"
  "                          | <marker s line prefix> C_IS_FLOW_OUT  <s flow line prefix>-->(n)\n"
  "                          | <marker s line prefix> C_IS_FLOW_IN   <s flow line prefix>-->(n)\n"
  "\n"
  "/* [68] */ <s block line prefix><--(n) ::= <s indent>-->(n)\n"
  "\n"
  "/* [69] */ <s flow line prefix><--(n) ::= <s indent>-->(n) <s separate in line>\n"
  "                                        | <s indent>-->(n)\n"
  "\n"
  "/* [70] */ <l empty><--(n,c) ::= <s line prefix>-->(n,c)    <b as line feed>\n"
  "                               | <s indent less than>-->(n) <b as line feed>\n"
  "/* [71] */ <b l trimmed><--(n,c) ::= <b non content> ( <l empty>-->(n,c)+ )\n"
  "/* [72] */ <b as space> ::= <b break>\n"
  "/* [73] */ <b l folded><--(n,c) ::= <b l trimmed>-->(n,c) | <b as space>\n"
  "/* [74] */ <s flow folded><--(n) ::= <s separate in line> <b l folded>-->(n,'FLOW-IN') <s flow line prefix>-->(n)\n"
  "                                   | <b l folded>-->(n,'FLOW-IN') <s flow line prefix>-->(n)\n"
  "/* [75] */ <c nb comment text> ::= <c comment> /* '#' */ ( <nb char>* )\n"
  "/* [76] */ <b comment> ::= <b non content>\n"
  "                         | <end of input>\n"
  "\n"
  "/* [77] */ <s b comment> ::= ( <s separate in line> <c nb comment text> | <s separate in line> ) <b comment>\n"
  "                           |                                                                     <b comment>\n"
  "\n"
  "/* [78] */ <l comment> ::= <s separate in line> <c nb comment text> <b comment>\n"
  "                         | <s separate in line>                     <b comment>\n"
  "\n"
  "/* [79] */ <s l comments> ::= ( <s b comment> | <start of line> ) ( <l comment>*) \n"
  "\n"

  " C_IS_BLOCK_KEY  ~ [^\\s\\S]\n"
  " C_IS_FLOW_KEY   ~ [^\\s\\S]\n"
  "<marker s separate> ::=\n"
  "event s_separate[] = nulled <marker s separate>\n"
  "<s separate><--(n,c) ::= <marker s separate> C_IS_BLOCK_OUT <s separate lines>-->(n)\n"
  "                       | <marker s separate> C_IS_BLOCK_IN  <s separate lines>-->(n)\n"
  "                       | <marker s separate> C_IS_FLOW_OUT  <s separate lines>-->(n)\n"
  "                       | <marker s separate> C_IS_FLOW_IN   <s separate lines>-->(n)\n"
  "                       | <marker s separate> C_IS_BLOCK_KEY <s separate in line>\n"
  "                       | <marker s separate> C_IS_FLOW_KEY  <s separate in line>\n"
  "\n"
  "/* [81] */ <s separate lines><--(n) ::= <s l comments> <s flow line prefix>-->(n) | <s separate in line>\n"
  "\n"
  "\n"
  "/* [82] */ <l directive> ::= <c directive> /* '%' */ ( <ns yaml directive> | <ns tag directive> | <ns reserved directive> ) <s l comments>\n"
  "/* [83] */ <ns reserved directive> ::= <ns directive name unit>*\n"
  "/* [84] */ <ns directive name> ::= <ns char>+\n"
  "/* [85] */ <ns directive parameter> ::= <ns char>+\n"
  "/* [86] */ <ns yaml directive> ::= \"YAML\" <s separate in line> <ns yaml version>\n"
  "/* [87] */ <ns yaml version> ::= ( <ns dec digit>+ ) '.' ( <ns dec digit> +)\n"
  "/* [88] */ <ns tag directive> ::= \"TAG\" <s separate in line> <c tag handle> <s separate in line> <ns tag prefix>\n"
  "/* [89] */ <c tag handle> ::= <c named tag handle>\n"
  "                            | <c secondary tag handle>\n"
  "                            | <c primary tag handle>\n"
  "/* [90] */ <c primary tag handle> ::= '!'\n"
  "/* [91] */ <c secondary tag handle> ::= \"!!\"\n"
  "/* [92] */ <c named tag handle> ::= <c tag> /* '!' */ ( <ns word char>+ ) <c tag> /* '!' */\n"
  "/* [93] */ <ns tag prefix> ::= <c ns local tag prefix>\n"
  "                             | <ns global tag prefix>\n"
  "/* [94] */ <c ns local tag prefix> ::= <c tag> /*'!' */ ( <ns uri char>* )\n"
  "/* [95] */ <ns global tag prefix> ::= <ns tag char> ( <ns uri char>* )\n"
  "/* [96] */ <c ns properties><--(n,c) ::= <c ns tag property>\n"
  "                                       | <c ns tag property> <s separate>-->(n,c) <c ns anchor property>\n"
  "                                       | <c ns anchor property>\n"
  "                                       | <c ns anchor property> <s separate>-->(n,c) <c ns tag property>\n"
  "/* [97] */ <c ns tag property> ::= <c verbatim tag>\n"
  "                                 | <c ns shorthand tag>\n"
  "                                 | <c non specific tag>\n"
  "/* [98] */ <c verbatim tag> ::= \"!<\" ( <ns uri char>+ ) '>'\n"
  "/* [99] */ <c ns shorthand tag> ::= <c tag handle> ( <ns tag char>+ )\n"
  "/* [100] */ <c non specific tag> ::= '!'\n"
  "/* [101] */ <c ns anchor property> ::= <c anchor> /* '&' */ <ns anchor name>\n"
  "\n"
  "/* [102] */ <ns anchor char> ::= /* <ns char> - <c flow indicator> */\n"
  "                              # 8 bit\n"
  "   [\\x{21}-\\x{2B}\\x{2D}-\\x{5A}\\x{5C}\\x{5E}-\\x{7A}\\x{7C}\\x{7E}]           # Printable ASCII minus ',', '[', ']', '{', '}'\n"
  "                              # 16 bit\n"
  "  | [\\x{85}]                  # Next Line (NEL)\n"
  "  | [\\x{A0}-\\x{D7FF}]:u       # Basic Multilingual Plane (BMP)\n"
  "  | [\\x{E000}-\\x{FEFE}\\x{FF00}-\\x{FFFD}]:u     # Additional Unicode Areas minus 0xFEFF\n"
  "  | [\\x{010000}-\\x{10FFFF}]:u # 32 bit\n"
  "/* [103] */ <ns anchor name> ::= ( <ns anchor char>+)\n"
  "/* [104] */ <c ns alias node> ::= <c alias> /* '*' */ <ns anchor name>\n"
  "/* [105] */ <e scalar> ::= <empty>\n"
  "/* [106] */ <e node> ::= <e scalar> # \"\"\n"
  "/* [107] */ <nb double char> ::=\n"
  "    <c ns esc char>\n"
  "  | ( # <nb json> - <c escape> /* '\\' */ - <c double quote>  /* '\"' */\n"
  "        [\\x{09}]                  # Tab character\n"
  "      | [\\x{20}\\x{21}\\x{23}-\\x{5B}\\x{5D}-\\x{10FFFF}]:u     # Non-C0-control characters minus \\ and \"\n"
  "    )\n"
  "\n"
  "/* [108] */ <ns double char> ::= /* <nb double char> - <s white> */\n"
  "    <c ns esc char>\n"
  "  | (\n"
  "      [\\x{21}\\x{23}-\\x{5B}\\x{5D}-\\x{10FFFF}]:u     # Non-C0-control characters minus \\, \", space and tab\n"
  "    )\n"
  "/* [109] */ <c double quoted><--(n,c) ::=\n"
  "  <c double quote> # '\"'\n"
  "  <nb double text>-->(n,c)\n"
  "  <c double quote>         # '\"'\n"

  "event nb_double_text[] = nulled <marker nb double text>\n"
  "<marker nb double text> ::=\n"
  "/* [110] */ <nb double text><--(n,c) ::= <marker nb double text> C_IS_FLOW_OUT   <nb double multi line>-->(n)\n"
  "                                       | <marker nb double text> C_IS_FLOW_IN    <nb double multi line>-->(n)\n"
  "                                       | <marker nb double text> C_IS_BLOCK_KEY  <nb double one line>\n"
  "                                       | <marker nb double text> C_IS_FLOW_KEY   <nb double one line>\n"


  "/* [111] */ <nb double one line> ::= <nb double char>*\n"
  "/* [112] */ <s double escaped><--(n) ::=\n"
  "  ( <s white>* )\n"
  "  <c escape>         # '\\'\n"
  "  <b non content>\n"
  "  ( <l empty>-->(n,'FLOW-IN')* )\n"
  "  <s flow line prefix>-->(n)\n"
  "\n"
  "/* [113] */ <s double break><--(n) ::=\n"
  "    <s double escaped>-->(n)\n"
  "  | <s flow folded>-->(n)\n"
  "\n"
  "/* [114] */ <nb ns double in line> ::= <nb ns double in line unit>*\n"
  "/* [115] */ <s double next line><--(n) ::=\n"
  "    <s double break>-->(n)\n"
  "  | <s double break>-->(n) \n"
  "  (\n"
  "    <ns double char> <nb ns double in line>\n"
  "    (\n"
  "        <s double next line>-->(n)\n"
  "      | ( <s white>* )\n"
  "    )\n"
  "  )\n"
  "/* [116] */ <nb double multi line><--(n) ::=\n"
  "  <nb ns double in line>\n"
  "  (\n"
  "      <s double next line>-->(n)\n"
  "    | ( <s white>* )\n"
  "  )\n"
  "/* [117] */ <c quoted quote> ::= \"''\"\n"
  "/* [118] */ <nb single char> ::=\n"
  "    <c quoted quote>\n"
  "  | ( # <nb json> - <c single quote> /* \"'\" */\n"
  "        [\\x{09}]                               # Tab character\n"
  "      | [\\x{20}-\\x{26}\\x{28}-\\x{10FFFF}]:u     # Non-C0-control characters minus '\n"
  "    )\n"
  "/* [119] */ <ns single char> ::= # <nb single char> - <s white>\n"
  "    <c quoted quote>\n"
  "  | ( # <nb json> - <c single quote> /* \"'\" */\n"
  "      [\\x{21}-\\x{26}\\x{28}-\\x{10FFFF}]:u     # Non-C0-control characters minus ', space and tab\n"
  "    )\n"
  "/* [120] */ <c single quoted><--(n,c) ::=\n"
  "  <c single quote>    # \"'\"\n"
  "  <nb single text>-->(n,c)\n"
  "  <c single quote>    # \"'\"\n"
  "/* [121] */\n"

  "event nb_single_text[] = nulled <marker nb single text>\n"
  "<marker nb single text> ::=\n"
  "<nb single text><--(n,c) ::= <marker nb single text> C_IS_FLOW_OUT  <nb single multi line>-->(n)\n"
  "                           | <marker nb single text> C_IS_FLOW_IN   <nb single multi line>-->(n)\n"
  "                           | <marker nb single text> C_IS_BLOCK_KEY <nb single one line>\n"
  "                           | <marker nb single text> C_IS_FLOW_KEY  <nb single one line>\n"

  "/* [122] */ <nb single one line> ::= <nb single char>*\n"
  "/* [123] */ <nb ns single in line> ::= <nb ns single in line unit>*\n"
  "/* [124] */ <s single next line><--(n) ::=\n"
  "    <s flow folded>-->(n)\n"
  "  | <s flow folded>-->(n)\n"
  "    (\n"
  "      <ns single char>\n"
  "      <nb ns single in line>\n"
  "      (\n"
  "          <s single next line>-->(n)\n"
  "        | ( <s white>* )\n"
  "      )\n"
  "    )\n"
  "/* [125] */ <nb single multi line><--(n) ::=\n"
  "  <nb ns single in line>\n"
  "  (\n"
  "      <s single next line>-->(n)\n"
  "    | ( <s white>* )\n"
  "  )\n"
  "/* [126] */ <ns plain first><--(c) ::=\n"
  "    ( # <ns char> - <c indicator>\n"
  "                                  # 8 bit\n"
  "        [\\x{24}\\x{26}\\x{28}\\x{29}\\x{2B}\\x{2E}-\\x{39}\\x{3B}-\\x{3D}\\x{41}-\\x{5A}\\x{5C}\\x{5E}\\x{5F}\\x{61}-\\x{7A}\\x{7E}]           # Printable ASCII minus <s space>, '-', '?', ':', ',', '[', ']', '{', '}', '#', '&', '*', '!', '|', '>', \"'\", '\"', '%', '@' and '`'\n"
  "                                  # 16 bit\n"
  "      | [\\x{85}]                  # Next Line (NEL)\n"
  "      | [\\x{A0}-\\x{D7FF}]:u       # Basic Multilingual Plane (BMP)\n"
  "      | [\\x{E000}-\\x{FEFE}\\x{FF00}-\\x{FFFD}]:u     # Additional Unicode Areas minus 0xFEFF\n"
  "      | [\\x{010000}-\\x{10FFFF}]:u # 32 bit\n"
  "        \n"
  "    )\n"
  "  | (\n"
  "      (\n"
  "          <c mapping key>       # '?'\n"
  "        | <c mapping value>     # ':'\n"
  "        | <c sequence entry>    # '-'\n"
  "      )\n"
  "      (?=<ns plain safe>-->(c))\n"
  "    )\n"

  "event ns_plain_safe[] = nulled <marker ns plain safe>\n"
  "<marker ns plain safe> ::=\n"
  "<ns plain safe><--(c) ::= <marker ns plain safe> C_IS_FLOW_OUT  <ns plain safe out>\n"
  "                        | <marker ns plain safe> C_IS_FLOW_IN   <ns plain safe in>\n"
  "                        | <marker ns plain safe> C_IS_BLOCK_KEY <ns plain safe out>\n"
  "                        | <marker ns plain safe> C_IS_FLOW_KEY  <ns plain safe in>\n"

  "/* [128] */ <ns plain safe out> ::= <ns char>\n"
  "/* [129] */ <ns plain safe in> ::= # <ns char> - <c flow indicator>\n"
  "                              # 8 bit\n"
  "   [\\x{21}-\\x{2B}\\x{2D}-\\x{5A}\\x{5C}\\x{5E}-\\x{7A}\\x{7C}\\x{7E}]           # Printable ASCII minus <s space>, ',', '[', ']', '{', '}'\n"
  "                              # 16 bit\n"
  "  | [\\x{85}]                  # Next Line (NEL)\n"
  "  | [\\x{A0}-\\x{D7FF}]:u       # Basic Multilingual Plane (BMP)\n"
  "  | [\\x{E000}-\\x{FEFE}\\x{FF00}-\\x{FFFD}]:u     # Additional Unicode Areas minus 0xFEFF\n"
  "  | [\\x{010000}-\\x{10FFFF}]:u # 32 bit\n"
  "\n"
  "/* [130] */ <ns plain char><--(c) ::=\n"
  "    ( # <ns plain safe>-->(c) - <c mapping value> /* ':' */ - <c comment> /* '#' */\n"
  "      <ns plain safe minus c mapping value and c comment>-->(c)\n"
  "    )\n"
  "  | (\n"
  "      /* [ lookbehind = ns-char ] */\n"
  "      <c comment>          # '#'\n"
  "    )\n"
  "  | (\n"
  "      <c mapping value> # ':'\n"
  "      (?=<ns plain safe>-->(c))\n"
  "    )\n"
  "/* [131] */\n"

  "event ns_plain[] = nulled <marker ns plain>\n"
  "<marker ns plain> ::=\n"
  "<ns plain><--(n,c) ::= <marker ns plain> C_IS_FLOW_OUT  <ns plain multi line>-->(n,'FLOW-OUT')\n"
  "                     | <marker ns plain> C_IS_FLOW_IN   <ns plain multi line>-->(n,'FLOW-IN')\n"
  "                     | <marker ns plain> C_IS_BLOCK_KEY <ns plain one line>-->('BLOCK-KEY')\n"
  "                     | <marker ns plain> C_IS_FLOW_KEY  <ns plain one line>-->('FLOW-KEY')\n"

  "/* [132] */ <nb ns plain in line><--(c) ::= <nb ns plain in line unit>-->(c)*\n"
  "/* [133] */ <ns plain one line><--(c) ::= <ns plain first>-->(c) <nb ns plain in line>-->(c)\n"
  "/* [134] */ <s ns plain next line><--(n,c) ::= <s flow folded>-->(n) <ns plain char>-->(c) <nb ns plain in line>-->(c)\n"
  "/* [135] */ <ns plain multi line><--(n,c) ::= <ns plain one line>-->(c) ( ( <s ns plain next line>-->(n,c)* ) )\n"
  "/* [136] */\n"

  "event in_flow[] = nulled <marker in flow>\n"
  "<marker in flow> ::=\n"
  "<in flow><--(n,c) ::= <marker in flow> C_IS_FLOW_OUT  <ns s flow seq entries>-->(n,'FLOW-IN')\n"
  "                    | <marker in flow> C_IS_FLOW_IN   <ns s flow seq entries>-->(n,'FLOW-IN')\n"
  "                    | <marker in flow> C_IS_BLOCK_KEY <ns s flow seq entries>-->(n,'FLOW-KEY')\n"
  "                    | <marker in flow> C_IS_FLOW_KEY  <ns s flow seq entries>-->(n,'FLOW-KEY')\n"

  "/* [137] */ <c flow sequence><--(n,c) ::=\n"
  "  <c sequence start>    # '['\n"
  "  <s separate maybe>-->(n,c)\n"
  "  <in flow maybe>-->(n,c)\n"
  "  <c sequence end>      # ']'\n"
  "\n"
  "/* [138] */ <ns s flow seq entries><--(n,c) ::= <ns flow seq entry>-->(n,c) <s separate maybe>-->(n,c)\n"
  "                                              | <ns flow seq entry>-->(n,c) <s separate maybe>-->(n,c) <c collect entry> /* ',' */ <s separate maybe>-->(n,c) <ns s flow seq entries maybe>-->(n,c)\n"
  "/* [139] */ <ns flow seq entry><--(n,c) ::= <ns flow pair>-->(n,c) | <ns flow node>-->(n,c)\n"
  "/* [140] */ <c flow mapping><--(n,c) ::=\n"
  "  <c mapping start>       # '{'\n"
  "  <s separate maybe>-->(n,c)\n"
  "  <ns s flow map entries maybe>-->(n,in_flow(c))\n"
  "  <c mapping end>         # '}'\n"
  "/* [141] */ <ns s flow map entries><--(n,c) ::= <ns flow map entry>-->(n,c) <s separate maybe>-->(n,c)\n"
  "                                              | <ns flow map entry>-->(n,c) <s separate maybe>-->(n,c) <c collect entry> /* ',' */ <s separate maybe>-->(n,c) <ns s flow map entries maybe>-->(n,c)\n"
  "/* [142] */ <ns flow map entry><--(n,c) ::=\n"
  "    (\n"
  "      <c mapping key>    # '?' (not followed by non-ws char)\n"
  "      <s separate>-->(n,c)\n"
  "      <ns flow map explicit entry>-->(n,c)\n"
  "    )\n"
  "  | <ns flow map implicit entry>-->(n,c)\n"
  "/* [143] */ <ns flow map explicit entry><--(n,c) ::=\n"
  "    <ns flow map implicit entry>-->(n,c)\n"
  "  | (\n"
  "      <e node>    # \"\"\n"
  "      <e node>    # \"\"\n"
  "    )\n"
  "/* [144] */ <ns flow map implicit entry><--(n,c) ::=\n"
  "    <ns flow map yaml key entry>-->(n,c)\n"
  "  | <c ns flow map empty key entry>-->(n,c)\n"
  "  | <c ns flow map json key entry>-->(n,c)\n"
  "/* [145] */ <ns flow map yaml key entry><--(n,c) ::=\n"
  "  <ns flow yaml node>-->(n,c)\n"
  "  (\n"
  "      (\n"
  "        <s separate maybe>-->(n,c)\n" 
  "        <c ns flow map separate value>-->(n,c)\n"
  "      )\n"
  "    | <e node>    # \"\"\n"
  "  )\n"
  "\n"
  "/* [146] */ <c ns flow map empty key entry><--(n,c) ::=\n"
  "  <e node>    # \"\"\n"
  "  <c ns flow map separate value>-->(n,c)\n"
  "\n"
  "/* [147] */ <c ns flow map separate value><--(n,c) ::=\n"
  "  <c mapping value>    # ':'\n"
  "  (?!<ns plain safe>-->(c))\n"
  "  (\n"
  "      (\n"
  "        <s separate>-->(n,c)\n"
  "        <ns flow node>-->(n,c)\n"
  "      )\n"
  "    | <e node>    # \"\"\n"
  "  )\n"
  "/* [148] */ <c ns flow map json key entry><--(n,c) ::=\n"
  "  <c flow json node>-->(n,c)\n"
  "  (\n"
  "      (\n"
  "        <s separate maybe>-->(n,c)\n"
  "        <c ns flow map adjacent value>-->(n,c)\n"
  "      )\n"
  "    | <e node>    # \"\"\n"
  "  )\n"
  "/* [149] */ <c ns flow map adjacent value><--(n,c) ::=\n"
  "  <c mapping value>          # ':'\n"
  "  (\n"
  "      (\n"
  "        <s separate maybe>-->(n,c)\n"
  "        <ns flow node>-->(n,c)\n"
  "      )\n"
  "    | <e node>    # \"\"\n"
  "  )\n"
  "/* [150] */ <ns flow pair><--(n,c) ::=\n"
  "    (\n"
  "      <c mapping key>     # '?' (not followed by non-ws char)\n"
  "      <s separate>-->(n,c)\n"
  "      <ns flow map explicit entry>-->(n,c)\n"
  "    )\n"
  "  | <ns flow pair entry>-->(n,c)\n"
  "/* [151] */ <ns flow pair entry><--(n,c) ::=\n"
  "    <ns flow pair yaml key entry>-->(n,c)\n"
  "  | <c ns flow map empty key entry>-->(n,c)\n"
  "  | <c ns flow pair json key entry>-->(n,c)\n"
  "/* [152] */ <ns flow pair yaml key entry><--(n,c) ::=\n"
  "  <ns s implicit yaml key>-->('FLOW-KEY')\n"
  "  <c ns flow map separate value>-->(n,c)\n"
  "/* [153] */ <c ns flow pair json key entry><--(n,c) ::=\n"
  "  <c s implicit json key>-->('FLOW-KEY')\n"
  "  <c ns flow map adjacent value>-->(n,c)\n"
  "/* [154] */ <ns s implicit yaml key><--(c) ::=\n"
  "  <ns flow yaml node>-->(0,c)\n"
  "  <s separate in line maybe>\n"
  "  /* At most 1024 characters altogether */\n"
  "/* [155] */ <c s implicit json key><--(c) ::=\n"
  "  <c flow json node>-->(0,c)\n"
  "  <s separate in line maybe>\n"
  "  /* At most 1024 characters altogether */\n"
  "/* [156] */ <ns flow yaml content><--(n,c) ::=\n"
  "  <ns plain>-->(n,c)\n"
  "/* [157] */ <c flow json content><--(n,c) ::=\n"
  "    <c flow sequence>-->(n,c)\n"
  "  | <c flow mapping>-->(n,c)\n"
  "  | <c single quoted>-->(n,c)\n"
  "  | <c double quoted>-->(n,c)\n"
  "/* [158] */ <ns flow content><--(n,c) ::=\n"
  "    <ns flow yaml content>-->(n,c)\n"
  "  | <c flow json content>-->(n,c)\n"
  "/* [159] */ <ns flow yaml node><--(n,c) ::=\n"
  "    <c ns alias node>\n"
  "  | <ns flow yaml content>-->(n,c)\n"
  "  | (\n"
  "      <c ns properties>-->(n,c)\n"
  "      (\n"
  "          (\n"
  "            <s separate>-->(n,c)\n"
  "            <ns flow yaml content>-->(n,c)\n"
  "          )\n"
  "        | <e scalar>\n"
  "      )\n"
  "    )\n"
  "/* [160] */ <c flow json node><--(n,c) ::= <c ns properties>-->(n,c) <s separate>-->(n,c) <c flow json content>-->(n,c)\n"
  "                                         |                                                <c flow json content>-->(n,c)\n"
  "\n"
  "/* [161] */ <ns flow node><--(n,c) ::=\n"
  "    <c ns alias node>\n"
  "  | <ns flow content>-->(n,c)\n"
  "  | (\n"
  "      <c ns properties>-->(n,c)\n"
  "      (\n"
  "        (\n"
  "          <s separate>-->(n,c)\n"
  "          <ns flow content>-->(n,c)\n"
  "        )\n"
  "        | <e scalar>\n"
  "      )\n"
  "    )\n"
  "/* [162] */ <c b block header><--(t) ::=\n"
  "  (\n"
  "      (\n"
  "        <c indentation indicator>\n"
  "        <c chomping indicator>-->(t)\n"
  "      )\n"
  "    | (\n"
  "        <c chomping indicator>-->(t)\n"
  "        <c indentation indicator>\n"
  "      )\n"
  "  )\n"
  "  <s b comment>\n"
  "event c_indentation_indicator_explicit[] = nulled <c indentation indicator explicit>\n"
  "<c indentation indicator explicit> ::=\n"
  "event c_indentation_indicator_auto_detect[] = nulled <c indentation indicator auto detect>\n"
  "<c indentation indicator auto detect> ::=\n"
  "/* [163] */ <c indentation indicator> ::= [\\x{31}-\\x{39}] <c indentation indicator explicit>   # 1-9\n"
  "/* [163 https://github.com/yaml/yaml-spec/issues/230 ] */ <c indentation indicator> ::= <empty> <c indentation indicator auto detect>\n"

  "T_IS_STRIP ~ [^\\s\\S]\n"
  "T_IS_KEEP  ~ [^\\s\\S]\n"
  "T_IS_CLIP  ~ [^\\s\\S]\n"
  "event c_chomping_indicator[] = nulled <marker c chomping indicator>\n"
  "<marker c chomping indicator> ::=\n"
  "<c chomping indicator><--(t) ::= <marker c chomping indicator> T_IS_STRIP '-'\n"
  "                               | <marker c chomping indicator> T_IS_KEEP  '+'\n"
  "                               | <marker c chomping indicator> T_IS_CLIP  <empty>\n"

  "event b_chomped_last[] = nulled <marker b chomped last>\n"
  "<marker b chomped last> ::=\n"
  "<b chomped last><--(t) ::= <marker b chomped last> T_IS_STRIP ( <b non content>  | :eof )\n"
  "                         | <marker b chomped last> T_IS_KEEP  ( <b as line feed> | :eof )\n"
  "                         | <marker b chomped last> T_IS_CLIP  ( <b as line feed> | :eof )\n"

  "event l_chomped_empty[] = nulled <marker l chomped empty>\n"
  "<marker l chomped empty> ::=\n"
  "/* [166] */ <l chomped empty><--(n,t) ::= <marker l chomped empty> T_IS_STRIP <l strip empty>-->(n)\n"
  "                                        | <marker l chomped empty> T_IS_KEEP  <l strip empty>-->(n)\n"
  "                                        | <marker l chomped empty> T_IS_CLIP  <l keep empty>-->(n)\n"

  "/* [167] */ <l strip empty><--(n) ::= ( <l strip empty unit>-->(n)* ) <l trail comments maybe>-->(n)\n"
  "/* [168] */ <l keep empty><--(n) ::= ( <l keep empty unit>-->(n)* ) <l trail comments maybe>-->(n)\n"
  "/* [169] */ <l trail comments><--(n) ::=\n"
  "  <s indent less than>-->(n)\n"
  "  <c nb comment text>\n"
  "  <b comment>\n"
  "  ( <l comment>* )\n"
  "/* [170] */ <c l literal><--(n) ::=\n"
  "  <c literal>                # '|'\n"
  "  <c b block header>-->(t)\n"
  "  <l literal content>-->(n+m,t)\n"
  "/* [171] */ <l nb literal text><--(n) ::=\n"
  "  ( <l empty>-->(n,'BLOCK-IN')* )\n"
  "  <s indent>-->(n) ( <nb char>+ )\n"
  "/* [172] */ <b nb literal next><--(n) ::=\n"
  "  <b as line feed>\n"
  "  <l nb literal text>-->(n)\n"
  "/* [173] */ <l literal content><--(n,t) ::= <l nb literal text>-->(n) (<b nb literal next>-->(n)* ) <b chomped last>-->(t) <l chomped empty>-->(n,t)\n"
  "                                          |                                                                                <l chomped empty>-->(n,t)\n"
  "/* [174] */ <c l folded><--(n) ::=\n"
  "  <c folded>                 # '>'\n"
  "  <c b block header>-->(t)\n"
  "  <l folded content>-->(n+m,t)\n"
  "/* [175] */ <s nb folded text><--(n) ::=\n"
  "  <s indent>-->(n)\n"
  "  <ns char>\n"
  "  ( <nb char>* )\n"
  "/* [176] */ <l nb folded lines><--(n) ::=\n"
  "  <s nb folded text>-->(n)\n"
  "  ( <l nb folded lines unit>-->(n)* )\n"
  "/* [177] */ <s nb spaced text><--(n) ::=\n"
  "  <s indent>-->(n)\n"
  "  <s white>\n"
  "  ( <nb char>* )\n"
  "/* [178] */ <b l spaced><--(n) ::=\n"
  "  <b as line feed>\n"
  "  ( <l empty>-->(n,'BLOCK-IN')* )\n"
  "/* [179] */ <l nb spaced lines><--(n) ::=\n"
  "  <s nb spaced text>-->(n)\n"
  "  ( <l nb spaced lines unit>-->(n)* )\n"
  "/* [180] */ <l nb same lines><--(n) ::=\n"
  "  ( <l empty>-->(n,'BLOCK-IN')* )\n"
  "  (\n"
  "      <l nb folded lines>-->(n)\n"
  "    | <l nb spaced lines>-->(n)\n"
  "  )\n"
  "/* [181] */ <l nb diff lines><--(n) ::=\n"
  "  <l nb same lines>-->(n)\n"
  "  ( <l nb diff lines unit>-->(n)* )\n"
  "/* [182] */ <l folded content><--(n,t) ::= <l nb diff lines>-->(n) <b chomped last>-->(t) <l chomped empty>-->(n,t)\n"
  "                                         |                                                <l chomped empty>-->(n,t)\n"
  "\n"
  "event l_block_sequence[] = nulled <marker l block sequence>\n"
  "<marker l block sequence> ::=\n"
  "/* [183] */ <l block sequence><--(n) ::= <marker l block sequence> M_IS_GREATER_THAN_ZERO ( <l block sequence unit>-->(n)+ )\n"
  "/* [184] */ <c l block seq entry><--(n) ::=\n"
  "  <c sequence entry>    # '-'\n"
  "  (?!<ns char>)\n"
  "  <s l block indented>-->(n,'BLOCK-IN')\n"
  "/* [185] */ <s l block indented><--(n,c) ::=\n"
  "    (\n"
  "      <s indent>-->(m)\n"
  "      (\n"
  "          <ns l compact sequence>-->(n+1+m)\n"
  "        | <ns l compact mapping>-->(n+1+m)\n"
  "      )\n"
  "    )\n"
  "  | <s l block node>-->(n,c)\n"
  "  | (\n"
  "      <e node>    # \"\"\n"
  "      <s l comments>\n"
  "    )\n"
  "/* [186] */ <ns l compact sequence><--(n) ::=\n"
  "  <c l block seq entry>-->(n)\n"
  "  ( <ns l compact sequence unit>-->(n)* )\n"

  "M_IS_GREATER_THAN_ZERO  ~ [^\\s\\S]\n"
  "event l_block_mapping[] = nulled <marker l block mapping>\n"
  "<marker l block mapping> ::=\n"
  "/* [187] */ <l block mapping><--(n) ::= <marker l block mapping> M_IS_GREATER_THAN_ZERO ( <l block mapping unit>-->(n)+ )\n"
  "/* [188] */ <ns l block map entry><--(n) ::=\n"
  "    <c l block map explicit entry>-->(n)\n"
  "  | <ns l block map implicit entry>-->(n)\n"
  "/* [189] */ <c l block map explicit entry><--(n) ::=\n"
  "  <c l block map explicit key>-->(n)\n"
  "  (\n"
  "      <l block map explicit value>-->(n)\n"
  "    | <e node>                        # \"\"\n"
  "  )\n"
  "/* [190] */ <c l block map explicit key><--(n) ::=\n"
  "  <c mapping key>                     # '?' (not followed by non-ws char)\n"
  "  <s l block indented>-->(n,'BLOCK-OUT')\n"
  "/* [191] */ <l block map explicit value><--(n) ::=\n"
  "  <s indent>-->(n)\n"
  "  <c mapping value>                   # ':' (not followed by non-ws char)\n"
  "  <s l block indented>-->(n,'BLOCK-OUT')\n"
  "/* [192] */ <ns l block map implicit entry><--(n) ::=\n"
  "  (\n"
  "      <ns s block map implicit key>\n"
  "    | <e node>    # \"\"\n"
  "  )\n"
  "  <c l block map implicit value>-->(n)\n"
  "/* [193] */ <ns s block map implicit key> ::=\n"
  "    <c s implicit json key>-->('BLOCK-KEY')\n"
  "  | <ns s implicit yaml key>-->('BLOCK-KEY')\n"
  "/* [194] */ <c l block map implicit value><--(n) ::=\n"
  "  <c mapping value>           # ':' (not followed by non-ws char)\n"
  "  (\n"
  "      <s l block node>-->(n,'BLOCK-OUT')\n"
  "    | (\n"
  "        <e node>    # \"\"\n"
  "        <s l comments>\n"
  "      )\n"
  "  )\n"
  "/* [195] */ <ns l compact mapping><--(n) ::=\n"
  "  <ns l block map entry>-->(n)\n"
  "  ( <ns l compact mapping unit>-->(n)* )\n"
  "/* [196] */ <s l block node><--(n,c) ::=\n"
  "    <s l block in block>-->(n,c)\n"
  "  | <s l flow in block>-->(n)\n"
  "/* [197] */ <s l flow in block><--(n) ::=\n"
  "  <s separate>-->(n+1,'FLOW-OUT')\n"
  "  <ns flow node>-->(n+1,'FLOW-OUT')\n"
  "  <s l comments>\n"
  "/* [198] */ <s l block in block><--(n,c) ::=\n"
  "    <s l block scalar>-->(n,c)\n"
  "  | <s l block collection>-->(n,c)\n"
  "/* [199] */ <s l block scalar><--(n,c) ::= <s separate>-->(n+1,c) <c ns properties>-->(n+1,c) <s separate>-->(n+1,c) ( <c l literal>-->(n) | <c l folded>-->(n) )\n"
  "                                         | <s separate>-->(n+1,c)                                                    ( <c l literal>-->(n) | <c l folded>-->(n) )\n"
  "/* [200] */ <s l block collection><--(n,c) ::= <s separate>-->(n+1,c) <c ns properties>-->(n+1,c) <s l comments> ( <seq space>-->(n,c) | <l block mapping>-->(n)  )\n"
  "                                             |                                                    <s l comments> ( <seq space>-->(n,c) | <l block mapping>-->(n)  )\n"

  "event seq_space[] = nulled <marker seq space>\n"
  "<marker seq space> ::=\n"
  "<seq space><--(n,c) ::= <marker seq space> C_IS_BLOCK_OUT <l block sequence>-->(n-1)\n"
  "                      | <marker seq space> C_IS_BLOCK_IN  <l block sequence>-->(n)\n"

  "/* [202] */ <l document prefix> ::= <c byte order mark> ( <l comment>* )\n"
  "                                  |                     ( <l comment>* )\n"
  "/* [203] */ <c directives end> ::= \"---\"\n"
  "/* [204] */ <c document end> ::=\n"
  "  \"...\"    # (not followed by non-ws char)\n"
  "\n"
  "/* [205] */ <l document suffix> ::=\n"
  "  <c document end>\n"
  "  <s l comments>\n"
  "/* [206] */ <c forbidden> ::=\n"
  "  :sol\n"
  "  (\n"
  "      <c directives end>\n"
  "    | <c document end>\n"
  "  )\n"
  "  (\n"
  "      <b char>\n"
  "    | <s white>\n"
  "    | :eof\n"
  "  )\n"
  "/* [207] */ <l bare document> ::=\n"
  "  <s l block node>-->(-1,'BLOCK-IN')\n"
  "  /* Excluding c-forbidden content */\n"
  "/* [208] */ <l explicit document> ::=\n"
  "  <c directives end>\n"
  "  (\n"
  "      <l bare document>\n"
  "    | (\n"
  "        <e node>    # \"\"\n"
  "        <s l comments>\n"
  "      )\n"
  "  )\n"
  "/* [209] */ <l directive document> ::=\n"
  "  ( <l directive>+ )\n"
  "  <l explicit document>\n"
  "/* [210] */ <l any document> ::=\n"
  "    <l directive document>\n"
  "  | <l explicit document>\n"
  "  | <l bare document>\n"
  "\n"
  "#\n"
  "# Take care, <l document prefix> is a nullable>, and a nullable cannot be used as an RHS of a sequence rule\n"
  "# So we use explicitly sequences of <l document prefix not nullable>, replaced by an empty item wherever necessary\n"
  "#\n"
  "\n"
  "/* [211] */ <l yaml stream> ::= ( <l document prefix not nullable>* ) <l any document maybe> ( <l yaml stream unit>* )\n"
  "                              |                                       <l any document maybe> ( <l yaml stream unit>* )\n"
  "\n"
  "<l document prefix not nullable> ::= <c byte order mark> ( <l comment>+ )\n"
  "                                  |                      ( <l comment>+ )\n"
  "<l yaml stream unit> ::= ( <l document suffix>+ ) ( <l document prefix not nullable>* ) <l any document maybe>\n"
  "                       | ( <l document suffix>+ )                                       <l any document maybe>\n"
  "                       | <c byte order mark>\n"
  "                       | <l comment>\n"
  "                       | <l explicit document>\n"
  "\n"
  "#\n"
  "# Helpers\n"
  "# -------\n"
  "<ns directive name unit> ::= <s separate in line> <ns directive parameter>\n"
  "<nb ns double in line unit> ::= ( <s white>* ) <ns double char>\n"
  "<nb ns single in line unit> ::= ( <s white>* ) <ns single char>\n"

  "event ns_plain_safe_minus_c_mapping_value_and_c_comment[] = nulled <marker ns plain safe minus c mapping value and c comment>\n"
  "<marker ns plain safe minus c mapping value and c comment> ::=\n"
  "<ns plain safe minus c mapping value and c comment><--(c) ::= <marker ns plain safe minus c mapping value and c comment> C_IS_FLOW_OUT  <ns plain safe out minus c mapping value and c comment>\n"
  "                                                            | <marker ns plain safe minus c mapping value and c comment> C_IS_FLOW_IN   <ns plain safe in minus c mapping value and c comment>\n"
  "                                                            | <marker ns plain safe minus c mapping value and c comment> C_IS_BLOCK_KEY <ns plain safe out minus c mapping value and c comment>\n"
  "                                                            | <marker ns plain safe minus c mapping value and c comment> C_IS_FLOW_KEY  <ns plain safe in minus c mapping value and c comment>\n"

  "<ns plain safe out minus c mapping value and c comment> ::= /* <ns char> - <c mapping value> - <c comment> */\n"
  "                              # 8 bit\n"
  "   [\\x{21}\\x{22}\\x{24}-\\x{39}\\x{3B}-\\x{7E}]           # Printable ASCII minus <s space>, ':', '#'\n"
  "                              # 16 bit\n"
  "  | [\\x{85}]                  # Next Line (NEL)\n"
  "  | [\\x{A0}-\\x{D7FF}]:u       # Basic Multilingual Plane (BMP)\n"
  "  | [\\x{E000}-\\x{FEFE}\\x{FF00}-\\x{FFFD}]:u     # Additional Unicode Areas minus 0xFEFF\n"
  "  | [\\x{010000}-\\x{10FFFF}]:u # 32 bit\n"
  "\n"
  "<ns plain safe in minus c mapping value and c comment> ::= # <ns char> - <c flow indicator>\n"
  "                              # 8 bit\n"
  "   [\\x{21}\\x{22}\\x{24}-\\x{2B}\\x{2D}-\\x{39}\\x{3B}-\\x{5A}\\x{5C}\\x{5E}-\\x{7A}\\x{7C}\\x{7E}] # Printable ASCII minus <s space>, ',', '[', ']', '{', '}', ':', '#'\n"
  "                              # 16 bit\n"
  "  | [\\x{85}]                  # Next Line (NEL)\n"
  "  | [\\x{A0}-\\x{D7FF}]:u       # Basic Multilingual Plane (BMP)\n"
  "  | [\\x{E000}-\\x{FEFE}\\x{FF00}-\\x{FFFD}]:u     # Additional Unicode Areas minus 0xFEFF\n"
  "  | [\\x{010000}-\\x{10FFFF}]:u # 32 bit\n"
  "<nb ns plain in line unit><--(c) ::=\n"
  "    ( <s white>* )\n"
  "    <ns plain char>-->(c)\n"
  "<s separate maybe><--(n,c) ::= <s separate>-->(n,c)\n"
  "<s separate maybe><--(n,c) ::=\n"
  "<in flow maybe><--(n,c) ::= <in flow>-->(n,c)\n"
  "<in flow maybe><--(n,c) ::=\n"
  "<ns s flow seq entries maybe><--(n,c) ::= <ns s flow seq entries>-->(n,c)\n"
  "<ns s flow seq entries maybe><--(n,c) ::=\n"
  "<ns s flow map entries maybe><--(n,c) ::= <ns s flow map entries>-->(n,in_flow(c))\n"
  "<ns s flow map entries maybe><--(n,c) ::=\n"
  "<s separate in line maybe> ::= <s separate in line>\n"
  "<s separate in line maybe> ::=\n"
  "<l trail comments maybe><--(n) ::= <l trail comments>-->(n)\n"
  "<l trail comments maybe><--(n) ::=\n"
  "<l strip empty unit><--(n) ::= <s indent less or equal>-->(n) <b non content>\n"
  "<l keep empty unit><--(n) ::= <l empty>-->(n,'BLOCK-IN')\n"
  "<l nb folded lines unit><--(n) ::= <b l folded>-->(n,'BLOCK-IN') <s nb folded text>-->(n)\n"
  "<l nb spaced lines unit><--(n) ::= <b l spaced>-->(n) <s nb spaced text>-->(n)\n"
  "<l nb diff lines unit><--(n) ::= <b as line feed> <l nb same lines>-->(n)\n"
  "<l block sequence unit><--(n) ::= <s indent>-->(n+1+m) <c l block seq entry>-->(n+1+m)\n"
  "<ns l compact sequence unit><--(n) ::= <s indent>-->(n) <c l block seq entry>-->(n)\n"
  "<l block mapping unit><--(n) ::= <s indent>-->(n+1+m) <ns l block map entry>-->(n+1+m)\n"
  "<ns l compact mapping unit><--(n) ::= <s indent>-->(n) <ns l block map entry>-->(n)\n"
  "<l any document maybe> ::= <l any document>\n"
  "<l any document maybe> ::=\n"
  "\n"
  "<luascript>\n"
  "re_spaces = marpaESLIF:marpaESLIFSymbol_new('regex', '[\\\\x{20}]+')\n"
  "auto_m = nil -- Auto-detected m\n"
  "m = nil -- Forced to nil to test its usage\n"
  "io.stdout:setvbuf 'no'\n"
  "io.stderr:setvbuf 'no'\n"
  "-- Indentation m is a global\n"
  "\n"
  "io.stdout:setvbuf 'no'    -- switch off buffering for stdout\n"
  "io.stderr:setvbuf 'no'    -- switch off buffering for stderr (not needed in practice)\n"
  "\n"
  "function pairsByKeys(t, f)\n"
  "   local a = {}\n"
  "   local k = {}\n"
  "   local v = {}\n"
  "   local i = 0\n"
  "   for n,m in pairs(t) do\n"
  "     i = i + 1\n"
  "     table.insert(a, i)\n"
  "     k[i] = n\n"
  "     v[i] = m\n"
  "   end\n"
  "   table.sort(a, f)\n"
  "   local j = 0      -- iterator variable\n"
  "   local iter = function ()   -- iterator function\n"
  "      j = j + 1\n"
  "      local key = k[a[j]]\n"
  "      local value = v[a[j]]\n"
  "      if key == nil then\n"
  "        return nil\n"
  "      else\n"
  "        return key, value\n"
  "      end\n"
  "   end\n"
  "   return iter\n"
  "end\n"
  "\n"
  "function _table2str(lua_table, raw_table, table_map, n, fold, indent)\n"
  "    indent = indent or 1\n"
  "    for k, v in pairsByKeys(lua_table) do\n"
  "        if type(k) == 'string' then\n"
  "            k = string.format('%q', k)\n"
  "        else\n"
  "            k = tostring(k)\n"
  "        end\n"
  "        n = n + 1; raw_table[n] = string.rep('    ', indent)\n"
  "        n = n + 1; raw_table[n] = '['\n"
  "        n = n + 1; raw_table[n] = k\n"
  "        n = n + 1; raw_table[n] = ']'\n"
  "        n = n + 1; raw_table[n] = ' = '\n"
  "        if type(v) == 'table' then\n"
  "            if fold and table_map[tostring(v)] then\n"
  "                n = n + 1; raw_table[n] = tostring(v)\n"
  "                n = n + 1; raw_table[n] = ',\\n'\n"
  "            else\n"
  "                table_map[tostring(v)] = true\n"
  "                n = n + 1; raw_table[n] = '{\\n'\n"
  "                n = _table2str(v, raw_table, table_map, n, fold, indent + 1)\n"
  "                n = n + 1; raw_table[n] = string.rep('    ', indent)\n"
  "                n = n + 1; raw_table[n] = '},\\n'\n"
  "            end\n"
  "        else\n"
  "            if type(v) == 'string' then\n"
  "                v = string.format('%q', v)\n"
  "            else\n"
  "                v = tostring(v)\n"
  "            end\n"
  "            n = n + 1; raw_table[n] = v\n"
  "            n = n + 1; raw_table[n] = ',\\n'\n"
  "        end\n"
  "    end\n"
  "    return n\n"
  "end\n"
  "\n"
  "function tableDump(lua_table, fold)\n"
  "    if type(lua_table) == 'table' then\n"
  "        local raw_table = {}\n"
  "        local table_map = {}\n"
  "        table_map[tostring(lua_table)] = true\n"
  "        local n = 0\n"
  "        n = n + 1; raw_table[n] = '{\\n'\n"
  "        n = _table2str(lua_table, raw_table, table_map, n, fold)\n"
  "        n = n + 1; raw_table[n] = '}'\n"
  "        return table.concat(raw_table, '')\n"
  "    else\n"
  "      if (lua_table == nil) then\n"
  "          return 'nil'\n"
  "      else\n"
  "        return lua_table\n"
  "      end\n"
  "    end\n"
  "end\n"
  "\n"
  "function in_flow(c)\n"
  "  local rc\n"
  "  if (c == 'FLOW-OUT')  then rc = 'FLOW-IN'  end\n"
  "  if (c == 'FLOW-IN')   then rc = 'FLOW-IN'  end\n"
  "  if (c == 'BLOCK-KEY') then rc = 'FLOW-KEY' end\n"
  "  if (c == 'FLOW-KEY')  then rc = 'FLOW-KEY' end\n"
  "  if (rc == nil) then\n"
  "    error('in_flow: Invalid context: '..tostring(c)..' [type(c)='..type(c)..']')\n"
  "  end\n"
  "  print('===========> in_flow(\"'..c..'\") returns: '..rc)\n"
  "  return rc\n"
  "end\n"
  "</luascript>\n"
  "\n"
  ;

static char *inputs[] = {
  "---\n"
  " doe: \"a deer, a female deer\"\n"
  " ray: \"a drop of golden sun\"\n"
  " pi: 3.14159\n"
  " xmas: true\n"
  " french-hens: 3\n"
  " calling-birds:\n"
  "   - huey\n"
  "   - dewey\n"
  "   - louie\n"
  "   - fred\n"
  " xmas-fifth-day:\n"
  "   calling-birds: four\n"
  "   french-hens: 3\n"
  "   golden-rings: 5\n"
  "   partridges:\n"
  "     count: 1\n"
  "     location: \"a pear tree\"\n"
  "   turtle-doves: two\n"
    };

#endif /* YAML_GRAMMAR_C */
