# Copyright 1999-2011 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/dev-haskell/texmath/texmath-0.5.0.1.ebuild,v 1.1 2011/04/23 16:27:48 slyfox Exp $

# ebuild generated by hackport 0.2.13

EAPI="3"

CABAL_FEATURES="bin lib profile haddock hscolour"
inherit haskell-cabal

DESCRIPTION="Conversion of LaTeX math formulas to MathML."
HOMEPAGE="http://github.com/jgm/texmath"
SRC_URI="http://hackage.haskell.org/packages/archive/${PN}/${PV}/${P}.tar.gz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="cgi test"

RDEPEND=">=dev-haskell/parsec-2
		dev-haskell/syb
		dev-haskell/xml
		>=dev-lang/ghc-6.8.2
		cgi? ( dev-haskell/json
			dev-haskell/cgi
			dev-haskell/utf8-string
		)
	"
DEPEND="${RDEPEND}
		>=dev-haskell/cabal-1.2"

src_configure() {
	cabal_src_configure \
		$(cabal_flag cgi) \
		$(cabal_flag test)
}

src_install() {
	cabal_src_install

	# remove test and it's data
	rm -f  "${ED}/usr/bin/texmath" 2> /dev/null
	rm -rf "${ED}/usr/share/${P}"/ghc-*/tests 2> /dev/null
}
