# Copyright 1999-2010 Gentoo Foundation
# Distributed under the terms of the GNU General Public License v2
# $Header: /var/cvsroot/gentoo-x86/media-sound/sndpeek/sndpeek-1.3-r2.ebuild,v 1.3 2010/09/16 17:17:53 scarabeus Exp $

EAPI=2
inherit eutils toolchain-funcs

DESCRIPTION="real-time audio visualization"
HOMEPAGE="http://soundlab.cs.princeton.edu/software/sndpeek/"
SRC_URI="http://soundlab.cs.princeton.edu/software/${PN}/files/${P}.tgz"

LICENSE="GPL-2"
SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="+alsa jack oss"

RDEPEND="media-libs/freeglut
	virtual/opengl
	virtual/glu
	x11-libs/libXmu
	x11-libs/libX11
	x11-libs/libXext
	media-libs/libsndfile
	jack? ( media-sound/jack-audio-connection-kit )
	alsa? ( media-libs/alsa-lib )
	app-admin/eselect-sndpeek"
DEPEND="${RDEPEND}"

src_prepare() {
	epatch "${FILESDIR}"/${P}-makefile.patch \
		"${FILESDIR}"/${P}-gcc-4.3.patch \
		"${FILESDIR}"/${P}-gcc-4.4.patch
}

pkg_setup() {
	if ! use alsa && ! use jack && ! use oss; then
		eerror "One of the following USE flags is needed: jack, alsa or oss"
		die "Please set one audio engine type"
	fi
}

compile_backend() {
	backend=$1
	cd "${S}/src/sndpeek"
	einfo "Compiling against ${backend}"
	emake -f "makefile.${backend}" CC=$(tc-getCC) \
		CXX=$(tc-getCXX) || die "emake failed"
	mv sndpeek{,-${backend}}
	emake -f "makefile.${backend}" clean
	cd -
}

src_compile() {
	use alsa && compile_backend alsa
	use jack && compile_backend jack
	use oss && compile_backend oss
}

src_install() {
	use alsa && dobin src/sndpeek/sndpeek-alsa
	use jack && dobin src/sndpeek/sndpeek-jack
	use oss && dobin src/sndpeek/sndpeek-oss
	dodoc AUTHORS README THANKS TODO VERSIONS
}

pkg_postinst() {
	elog "Sndpeek now can use many audio engines, so you can specify audio engine"
	elog "with sndpeek-{jack,alsa,oss}"
	elog "Or you can use 'eselect sndpeek' to set the audio engine"

	einfo "Calling eselect sndpeek update..."
	eselect sndpeek update --if-unset
}
