#
# Copyright (c) 2003,2004 ALT Linux Ltd.
# Copyright (c) 2003,2004 Stanislav Ievlev <inger@altlinux.org>
#
# upgrade.awk - helper script to convert config to new format
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307,
# USA.
#

function prn()
{
	if (i == 0)
	{
	    if (!slaves[link[0]]) print link[0],real[0],weight[0]
	}
	else
	{
	    print link[1],real[1],real[0];
	    slaves[link[1]]=1;
	}
}

BEGIN	{
    OFS="\t";
    not_first = 0;
}

/name.*="candidate"/	{
	if (not_first) prn();
	i = 0;
	not_first = 1;
}

/name.*=.*"slave"/	{
	prn();
	i = 1;
}

/^link/	{ link[i]=$2 }
/^real/	{ real[i]=$2 }
/^weight/	{ weight[i]=$2 }

#hack for xinclude
/etc.gcc-common.gcc-3.3/ { weight[i]=40 }
/etc.gcc-common.gcc-3.2/ { weight[i]=30 }
/etc.gcc-common.gcc-2.96/ { weight[i]=20 }
/etc.gcc-common.gcc-2.95/ { weight[i]=10 }

END		{ prn() }
