# encoding: utf-8

# ***************************************************************************
#
# Copyright (c) 2000 - 2012 Novell, Inc.
# All Rights Reserved.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of version 2 of the GNU General Public License as
# published by the Free Software Foundation.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.   See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, contact Novell, Inc.
#
# To contact Novell about this file by physical or electronic mail,
# you may find current contact information at www.novell.com
#
# ***************************************************************************
# This file is generated by inetd/src/all-services.sh - DO NOT EDIT! --
# Maintainer: Lukas Ocilka <locilka@suse.cz>
# $Id$
module Yast
  module InetdDefaultConfXinetdInclude
    def initialize_inetd_default_conf_xinetd(include_target)
      textdomain "inetd"
      Yast.import "XVersion"

      @x_bin_path = GetBinPath()

      @default_conf = [
        {
          "comment"        => " admind: admin daemon for thin clients\n" +
            " uses ident and host name lookups for authentication\n" +
            " security: weak authentication, just enough for thin clients\n" +
            " client: adminc.pl\n" +
            " default config file: /etc/opt/SLES/POS/admind.conf\n",
          "comment_inside" => "\tserver_args     = -v\n",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/admind",
          "package"        => "admind",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "admind",
          "server"         => "/usr/sbin/admind",
          "server_args"    => "",
          "service"        => "admind",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype            = UNLISTED\n\tport            = 8888\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: Amanda backup client\n" +
            "\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "amanda",
          "iid"            => "1:./etc/xinetd.d/amanda",
          "package"        => "amanda",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "amanda",
          "server"         => "/usr/lib/amanda/amandad",
          "server_args"    => "-auth=bsdudp amdump",
          "service"        => "amanda",
          "socket_type"    => "dgram",
          "unparsed"       => "",
          "user"           => "amanda",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n" +
            " description: Amanda backup server with indexing capabilities\n" +
            "\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "amanda",
          "iid"            => "1:./etc/xinetd.d/amandaidx",
          "package"        => "amanda",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "amandaidx",
          "server"         => "/usr/lib/amanda/amindexd",
          "server_args"    => "",
          "service"        => "amandaidx",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "amanda",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: Amanda backup server with indexing capabilities\n" +
            "\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "amanda",
          "iid"            => "1:./etc/xinetd.d/amidxtape",
          "package"        => "amanda",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "amidxtape",
          "server"         => "/usr/lib/amanda/amidxtaped",
          "server_args"    => "",
          "service"        => "amidxtape",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "amanda",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: This is an enhanced version of the CMU BOOTP server which was \n" +
            " derived from the original BOOTP server created by Bill Croft at Stanford.\n" +
            " This version merges all the enhancements and bug-fixes from the\n" +
            " NetBSD, Columbia, and other versions.\n" +
            "       \n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "root",
          "iid"            => "1:./etc/xinetd.d/bootp-DD2",
          "package"        => "bootp-DD2",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "bootp-DD2",
          "server"         => "/usr/sbin/bootpd",
          "server_args"    => "-c /tftpboot",
          "service"        => "bootps",
          "socket_type"    => "dgram",
          "unparsed"       => "",
          "user"           => "root",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n description: A chargen server. This is the tcp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/chargen",
          "package"        => "",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "chargen",
          "server"         => "",
          "server_args"    => "",
          "service"        => "chargen",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= INTERNAL\n" +
            "\tid\t\t= chargen-stream\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: A chargen server. This is the udp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/chargen-udp",
          "package"        => "",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "chargen-udp",
          "server"         => "",
          "server_args"    => "",
          "service"        => "chargen",
          "socket_type"    => "dgram",
          "unparsed"       => "\ttype\t\t= INTERNAL UNLISTED\n" +
            "\tid\t\t= chargen-dgram\n" +
            "\tport\t\t= 19\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => true
        },
        {
          "comment"        => "",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/cups-lpd",
          "package"        => "cups",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "cups-lpd",
          "server"         => "/usr/lib/cups/daemon/cups-lpd",
          "server_args"    => "cups-lpd -o document-format=application/octet-stream",
          "service"        => "printer",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags       = NAMEINARGS\n",
          "user"           => "lp",
          "wait"           => false
        },
        {
          "comment"        => " CVS pserver (remote acces to your CVS repositories)  \n" +
            " Please read the section on security and passwords in the CVS manual,\n" +
            " before you enable this.\n" +
            " default: off\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/cvs",
          "package"        => "cvs",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "cvs",
          "server"         => "/usr/bin/cvs",
          "server_args"    => "-f --allow-root=/home/cvsroot pserver",
          "service"        => "cvspserver",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: A daytime server. This is the tcp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/daytime",
          "package"        => "",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "daytime",
          "server"         => "",
          "server_args"    => "",
          "service"        => "daytime",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= INTERNAL\n" +
            "\tid\t\t= daytime-stream\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: A daytime server. This is the udp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/daytime-udp",
          "package"        => "",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "daytime-udp",
          "server"         => "",
          "server_args"    => "",
          "service"        => "daytime",
          "socket_type"    => "dgram",
          "unparsed"       => "\ttype\t\t= INTERNAL UNLISTED\n" +
            "\tid\t\t= daytime-dgram\n" +
            "\tport\t\t= 13\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n description: A discard server. This is the tcp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/discard",
          "package"        => "",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "discard",
          "server"         => "",
          "server_args"    => "",
          "service"        => "discard",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= INTERNAL\n" +
            "\tid\t\t= discard-stream\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: A discard server. This is the udp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/discard-udp",
          "package"        => "",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "discard-udp",
          "server"         => "",
          "server_args"    => "",
          "service"        => "discard",
          "socket_type"    => "dgram",
          "unparsed"       => "\ttype\t\t= INTERNAL UNLISTED\n" +
            "\tid\t\t= discard-dgram\n" +
            "\tport\t\t= 9\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n description: An echo server. This is the tcp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/echo",
          "package"        => "",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "echo",
          "server"         => "",
          "server_args"    => "",
          "service"        => "echo",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= INTERNAL\n" +
            "\tid\t\t= echo-stream\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: An echo server. This is the udp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/echo-udp",
          "package"        => "",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "echo-udp",
          "server"         => "",
          "server_args"    => "",
          "service"        => "echo",
          "socket_type"    => "dgram",
          "unparsed"       => "\ttype\t\t= INTERNAL UNLISTED\n" +
            "\tid\t\t= echo-dgram\n" +
            "\tport\t\t= 7\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n" +
            " description: The encrypting kerberized rlogin server accepts BSD-style rlogin sessions, \\\n" +
            "              but uses Kerberos 5 authentication.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/eklogin",
          "package"        => "krb5-apps-servers",
          "protocol"       => "",
          "rpc_version"    => "",
          "script"         => "eklogin",
          "server"         => "/usr/lib/mit/sbin/klogind",
          "server_args"    => "-e -5 -c",
          "service"        => "eklogin",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= REUSE\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: The fam server answers requests via libfam.  \\\n" +
            "\tIt is used to report file or directory changes to monitoring \\\n" +
            "\tclients. \n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "root",
          "iid"            => "1:./etc/xinetd.d/fam",
          "package"        => "fam-server",
          "protocol"       => "tcp",
          "rpc_version"    => "2",
          "script"         => "fam",
          "server"         => "/usr/sbin/famd",
          "server_args"    => "",
          "service"        => "fam",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype            = RPC UNLISTED\n\trpc_number      = 391002\n",
          "user"           => "root",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n" +
            " description: The finger server answers finger requests. Finger is \\\n" +
            "\ta protocol that allows remote users to see information such \\\n" +
            "\tas login name and login time for currently logged in users.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/finger",
          "package"        => "finger-server",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "finger",
          "server"         => "/usr/sbin/in.fingerd",
          "server_args"    => "-w",
          "service"        => "finger",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: The git server offers access to git repositories\n",
          "comment_inside" => "",
          "enabled"        => true,
          "group"          => "nogroup",
          "iid"            => "1:./etc/xinetd.d/git",
          "package"        => "git-core",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "git",
          "server"         => "/usr/bin/git",
          "server_args"    => "daemon --syslog --inetd --base-path=\"/srv/git\"",
          "service"        => "git",
          "socket_type"    => "stream",
          "unparsed"       => "        type            = UNLISTED\n" +
            "        port            = 9418\n" +
            "        log_on_failure  += USERID\n",
          "user"           => "git-daemon",
          "wait"           => false
        },
        {
          "comment"        => " vbox (Voice Box)\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/i4l-vbox",
          "package"        => "i4l-vbox",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "i4l-vbox",
          "server"         => "/usr/sbin/vboxd",
          "server_args"    => "",
          "service"        => "vboxd",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => "\n imap - pop2 mail daemon\n\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/imap",
          "package"        => "imap",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "imap",
          "server"         => "/usr/sbin/ipop2d",
          "server_args"    => "",
          "service"        => "pop2",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => "\n imap - pop3 mail daemon\n\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "15:./etc/xinetd.d/imap",
          "package"        => "imap",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "imap",
          "server"         => "/usr/sbin/ipop3d",
          "server_args"    => "",
          "service"        => "pop3",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => "\n imap - pop3 mail daemon over tls/ssl\n\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "29:./etc/xinetd.d/imap",
          "package"        => "imap",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "imap",
          "server"         => "/usr/sbin/ipop3d",
          "server_args"    => "",
          "service"        => "pop3s",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => "\n imap - imap mail daemon\n\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "43:./etc/xinetd.d/imap",
          "package"        => "imap",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "imap",
          "server"         => "/usr/sbin/imapd",
          "server_args"    => "",
          "service"        => "imap",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => "\n imap - imap mail daemon over tls/ssl\n\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "57:./etc/xinetd.d/imap",
          "package"        => "imap",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "imap",
          "server"         => "/usr/sbin/imapd",
          "server_args"    => "",
          "service"        => "imaps",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: The kerberized rlogin server accepts BSD-style rlogin sessions, \\\n" +
            "              but uses Kerberos 5 authentication.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/klogin",
          "package"        => "krb5-apps-servers",
          "protocol"       => "",
          "rpc_version"    => "",
          "script"         => "klogin",
          "server"         => "/usr/lib/mit/sbin/klogind",
          "server_args"    => "-5",
          "service"        => "klogin",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= REUSE\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: The kerberized rshell server accepts rshell commands \\\n" +
            "              authenticated and encrypted with Kerberos 5.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/kshell",
          "package"        => "krb5-apps-servers",
          "protocol"       => "",
          "rpc_version"    => "",
          "script"         => "kshell",
          "server"         => "/usr/lib/mit/sbin/kshd",
          "server_args"    => "-e -5",
          "service"        => "kshell",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= REUSE\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: The kerberized telnet server accepts normal telnet sessions, \\\n" +
            "              but can also use Kerberos 5 authentication.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/ktelnet",
          "package"        => "krb5-apps-servers",
          "protocol"       => "",
          "rpc_version"    => "",
          "script"         => "ktelnet",
          "server"         => "/usr/lib/mit/sbin/telnetd",
          "server_args"    => "",
          "service"        => "telnet",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= REUSE\n\tlog_on_failure\t+= USERID\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: on\n description: NRPE (Nagios Remote Plugin Executor)\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "nagios",
          "iid"            => "1:./etc/xinetd.d/nagios-nrpe",
          "package"        => "nagios-nrpe-client",
          "protocol"       => "",
          "rpc_version"    => "",
          "script"         => "nagios-nrpe",
          "server"         => "/usr/sbin/nrpe",
          "server_args"    => "-c /etc/nagios/nrpe.cfg --inetd",
          "service"        => "nrpe",
          "socket_type"    => "stream",
          "unparsed"       => "       \tflags           = REUSE\n" +
            "        type            = UNLISTED\n" +
            "        port            = 5666    \n" +
            "       \tlog_on_failure  += USERID\n" +
            "\tonly_from       = 127.0.0.1\n",
          "user"           => "nagios",
          "wait"           => false
        },
        {
          "comment"        => " netstat (like the services finger and systat) give out user information which\n" +
            " may be valuable to potential \"system crackers.\" Many sites choose to disable\n" +
            " some or all of these services to improve security.  Try \"telnet localhost\n" +
            " systat\" and \"telnet localhost netstat\" to see that information yourself!\n" +
            "\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/netstat",
          "package"        => "net-tools",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "netstat",
          "server"         => "/bin/netstat",
          "server_args"    => "-a",
          "service"        => "netstat",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: NSCA (Nagios Service Check Acceptor)\n",
          "comment_inside" => "\tonly_from       = 127.0.0.1\n",
          "enabled"        => false,
          "group"          => "nagios",
          "iid"            => "1:./etc/xinetd.d/nsca",
          "package"        => "nagios-nsca",
          "protocol"       => "",
          "rpc_version"    => "",
          "script"         => "nsca",
          "server"         => "/usr/bin/nsca",
          "server_args"    => "-c /etc/nagios/nsca.cfg --inetd",
          "service"        => "nsca",
          "socket_type"    => "stream",
          "unparsed"       => "       \tflags           = REUSE\n" +
            "        type            = UNLISTED\n" +
            "        port            = 5667\n" +
            "       \tlog_on_failure  += USERID\n",
          "user"           => "nagios",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: The talk server accepts talk requests for chatting with users \\\n" +
            "       on other systems.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "tty",
          "iid"            => "1:./etc/xinetd.d/ntalk",
          "package"        => "talk-server",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "ntalk",
          "server"         => "/usr/sbin/in.talkd",
          "server_args"    => "",
          "service"        => "ntalk",
          "socket_type"    => "dgram",
          "unparsed"       => "\tflags\t\t= IPv4\n",
          "user"           => "nobody",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n" +
            " description: The identd server provides a means to determine the identity\n" +
            " of a user of a particular TCP connection. \n" +
            "\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/pidentd",
          "package"        => "pidentd",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "pidentd",
          "server"         => "/usr/sbin/in.identd",
          "server_args"    => "-i -t120",
          "service"        => "ident",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= IPv6\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: The ftpd server serves FTP connections. It uses normal, \\\n" +
            "       unencrypted usernames and passwords for authentication. This ftpd is \\\n" +
            "       the pure-ftpd.\n" +
            "    ** NOTE ** when using pure-ftpd from xinetd the arguments to control\n" +
            "               it's behaviour should be added here in this file in the\n" +
            "               \"server_args\" line since the configuration file\n" +
            "               /etc/pure-ftpd.conf is only for standalone pure-ftpd.\n" +
            "               The command \"/usr/sbin/pure-config-args /etc/pure-ftpd.conf\"\n" +
            "               will print the arguments needed for behaviour like standalone\n" +
            "               pure-ftpd.\n",
          "comment_inside" => "    server_args =\n",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/pure-ftpd",
          "package"        => "pure-ftpd",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "pure-ftpd",
          "server"         => "/usr/sbin/pure-ftpd",
          "server_args"    => "",
          "service"        => "ftp",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => "\n qpopper - pop3 mail daemon\n\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/qpopper",
          "package"        => "qpopper",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "qpopper",
          "server"         => "/usr/sbin/popper",
          "server_args"    => "-s",
          "service"        => "pop3",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description:\n" +
            " Rexecd is the server for the rexec program. The server provides remote \n" +
            " execution facilities with authentication based on user names and \n" +
            " passwords.\n" +
            "\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "root",
          "iid"            => "1:./etc/xinetd.d/rexec",
          "package"        => "rsh-server",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "rexec",
          "server"         => "/usr/sbin/tcpd",
          "server_args"    => "/usr/sbin/in.rexecd",
          "service"        => "exec",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= NAMEINARGS\n" +
            "\tlog_on_success\t+= USERID\n" +
            "\tlog_on_failure\t+= USERID\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description:\n" +
            " Rlogind is a server for the rlogin program. The server provides remote \n" +
            " execution with authentication based on privileged port numbers from trusted\n" +
            " host\n" +
            "\n",
          "comment_inside" => "\tserver_args\t= /usr/sbin/in.rlogind -a\n",
          "enabled"        => false,
          "group"          => "root",
          "iid"            => "1:./etc/xinetd.d/rlogin",
          "package"        => "rsh-server",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "rlogin",
          "server"         => "/usr/sbin/tcpd",
          "server_args"    => "/usr/sbin/in.rlogind",
          "service"        => "login",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= NAMEINARGS\n" +
            "\tlog_on_success\t+= USERID\n" +
            "\tlog_on_failure\t+= USERID\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " For man on the fly and ht://dig (full text search)\n \n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/rman",
          "package"        => "rman",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "rman",
          "server"         => "/usr/sbin/http-rman",
          "server_args"    => "",
          "service"        => "http-rman",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description:\n" +
            " The rshd server is a server for the rcmd(3) routine and, \n" +
            " consequently, for the rsh(1) program. The server provides \n" +
            " remote execution facilities with authentication based on \n" +
            " privileged port numbers from trusted hosts.\n" +
            "\n",
          "comment_inside" => "\tserver_args\t= /usr/sbin/in.rshd -L\n",
          "enabled"        => false,
          "group"          => "root",
          "iid"            => "1:./etc/xinetd.d/rsh",
          "package"        => "rsh-server",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "rsh",
          "server"         => "/usr/sbin/tcpd",
          "server_args"    => "/usr/sbin/in.rshd -aL",
          "service"        => "shell",
          "socket_type"    => "stream",
          "unparsed"       => "\tflags\t\t= NAMEINARGS\n" +
            "\tlog_on_success\t+= USERID\n" +
            "\tlog_on_failure\t+= USERID\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: rsync file transfer daemon\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/rsync",
          "package"        => "rsync",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "rsync",
          "server"         => "/usr/sbin/rsyncd",
          "server_args"    => "--daemon",
          "service"        => "rsync",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: The saned provides scanner service via the network.  \\\n" +
            "\tApplications like kooka, xsane or xscanimage can use the remote \\\n" +
            "\tscanner. \n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "root",
          "iid"            => "1:./etc/xinetd.d/sane-port",
          "package"        => "sane-backends",
          "protocol"       => "",
          "rpc_version"    => "",
          "script"         => "sane-port",
          "server"         => "/usr/sbin/saned",
          "server_args"    => "",
          "service"        => "sane-port",
          "socket_type"    => "stream",
          "unparsed"       => "\tport        = 6566\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: An internal xinetd service, listing active servers.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/servers",
          "package"        => "",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "servers",
          "server"         => "",
          "server_args"    => "",
          "service"        => "servers",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= INTERNAL UNLISTED\n" +
            "\tport\t\t= 9099\n" +
            "\tonly_from\t= 127.0.0.1\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: An internal xinetd service, listing active services.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/services",
          "package"        => "",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "services",
          "server"         => "",
          "server_args"    => "",
          "service"        => "services",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= INTERNAL UNLISTED\n" +
            "\tport\t\t= 9098\n" +
            "\tonly_from\t= 127.0.0.1\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "",
          "wait"           => false
        },
        {
          "comment"        => "\n" +
            " The Internet secure UUCP service.\n" +
            "\n" +
            " Find UUCP config examples at\n" +
            "     /usr/share/doc/packages/uucp/cfg_example/taylor_config/\n" +
            " There are also the suucp-*.conf files required for a stunnel\n" +
            " driven SUUCP client and server configuration.\n" +
            "\n" +
            " This xinetd configuration file covers the servers side with\n" +
            " suucp-server.conf as argument for the stunnel exectuable.\n" +
            "\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/suucp",
          "package"        => "",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "suucp",
          "server"         => "/usr/sbin/stunnel",
          "server_args"    => "/etc/uucp/suucp-server.conf",
          "service"        => "suucp",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "uucp",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: readonly access to a subversion repository\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "svn",
          "groups"         => "yes",
          "iid"            => "1:./etc/xinetd.d/svnserve",
          "package"        => "subversion",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "svnserve",
          "server"         => "/usr/bin/svnserve",
          "server_args"    => "--read-only --root=/srv/svn/repos --inetd",
          "service"        => "svn",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "svn",
          "wait"           => false
        },
        {
          "comment"        => " SWAT is the Samba Web Administration Tool.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/swat",
          "package"        => "samba",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "swat",
          "server"         => "/usr/sbin/swat",
          "server_args"    => "",
          "service"        => "swat",
          "socket_type"    => "stream",
          "unparsed"       => "\tonly_from       =  127.0.0.1\n\tlog_on_failure  += USERID\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " Finger, systat and netstat give out user information which may be\n" +
            " valuable to potential \"system crackers.\" Many sites choose to disable\n" +
            " some or all of these services to improve security.\n" +
            " Try \"telnet localhost systat\" and \"telnet localhost netstat\" to see that\n" +
            " information yourself!\n" +
            "\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/systat",
          "package"        => "procps",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "systat",
          "server"         => "/bin/ps",
          "server_args"    => "-auwwx",
          "service"        => "systat",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: The talk server accepts talk requests for chatting with users \\\n" +
            "       on other systems.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "tty",
          "iid"            => "1:./etc/xinetd.d/talk",
          "package"        => "talk-server",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "talk",
          "server"         => "/usr/sbin/in.talkd",
          "server_args"    => "",
          "service"        => "talk",
          "socket_type"    => "dgram",
          "unparsed"       => "\tflags\t\t= IPv4\n",
          "user"           => "nobody",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n" +
            " description: Telnet is the old login server which is INSECURE and should \\\n" +
            "\ttherefore not be used. Use secure shell (openssh).\n" +
            "\tIf you need telnetd not to \"keep-alives\" (e.g. if it runs over a ISDN \\\n" +
            "\tuplink), add \"-n\".  See 'man telnetd' for more details.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/telnet",
          "package"        => "telnet-server",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "telnet",
          "server"         => "/usr/sbin/in.telnetd",
          "server_args"    => "",
          "service"        => "telnet",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: tftp service is provided primarily for booting or when a \\\n" +
            " \trouter need an upgrade. Most sites run this only on machines acting as\n" +
            " \t\"boot servers\".\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/tftp",
          "package"        => "tftp",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "tftp",
          "server"         => "/usr/sbin/in.tftpd",
          "server_args"    => "-s /tftpboot",
          "service"        => "tftp",
          "socket_type"    => "dgram",
          "unparsed"       => "\tflags\t\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => true
        },
        {
          "comment"        => " default: off\n" +
            " description: An RFC 868 time server. This is the tcp version,\n" +
            " which is used by rdate.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/time",
          "package"        => "",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "time",
          "server"         => "",
          "server_args"    => "",
          "service"        => "time",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= INTERNAL\n" +
            "\tid\t\t= time-stream\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n description: An RFC 868 time server. This is the udp version.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/time-udp",
          "package"        => "",
          "protocol"       => "udp",
          "rpc_version"    => "",
          "script"         => "time-udp",
          "server"         => "",
          "server_args"    => "",
          "service"        => "time",
          "socket_type"    => "dgram",
          "unparsed"       => "\ttype\t\t= INTERNAL UNLISTED\n" +
            "\tid\t\t= time-dgram\n" +
            "\tport\t\t= 37\n" +
            "\tFLAGS\t\t= IPv6 IPv4\n",
          "user"           => "root",
          "wait"           => true
        },
        {
          "comment"        => "\n" +
            " The Internet UUCP service.\n" +
            " \n" +
            " Find UUCP config examples at\n" +
            "     /usr/share/doc/packages/uucp/cfg_example/taylor_config/\n" +
            "\n",
          "comment_inside" => " Activate the bind statement if you use the secure UUCP (SUUCP) service.  In\n" +
            " this case you do not need to bind uucp on any external interface.\n" +
            "    bind\t= localhost\n",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/uucp",
          "package"        => "uucp",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "uucp",
          "server"         => "/usr/lib/uucp/uucico",
          "server_args"    => "-l",
          "service"        => "uucp",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "uucp",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: This serves out a VNC connection which starts at a KDM login \\\n" +
            "\tprompt. This VNC connection has a resolution of 1024x768, 16bit depth.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/vnc",
          "package"        => "xorg-x11-Xvnc",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "vnc",
          "server"         => Ops.add(@x_bin_path, "/Xvnc"),
          "server_args"    => "-noreset -inetd -once -query localhost -geometry 1024x768 -depth 16",
          "service"        => "vnc1",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= UNLISTED\n\tport\t\t= 5901\n",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: This serves out a VNC connection which starts at a KDM login \\\n" +
            "\tprompt. This VNC connection has a resolution of 1280x1024, 16bit depth.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "16:./etc/xinetd.d/vnc",
          "package"        => "xorg-x11-Xvnc",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "vnc",
          "server"         => Ops.add(@x_bin_path, "/Xvnc"),
          "server_args"    => "-noreset -inetd -once -query localhost -geometry 1280x1024 -depth 16",
          "service"        => "vnc2",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= UNLISTED\n\tport\t\t= 5902\n",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: This serves out a VNC connection which starts at a KDM login \\\n" +
            "\tprompt. This VNC connection has a resolution of 1600x1200, 16bit depth.\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "31:./etc/xinetd.d/vnc",
          "package"        => "xorg-x11-Xvnc",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "vnc",
          "server"         => Ops.add(@x_bin_path, "/Xvnc"),
          "server_args"    => "-noreset -inetd -once -query localhost -geometry 1600x1200 -depth 16",
          "service"        => "vnc3",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= UNLISTED\n\tport\t\t= 5903\n",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: This serves out the vncviewer Java applet for the VNC \\\n" +
            "\tserver running on port 5901, (vnc port 1).\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "46:./etc/xinetd.d/vnc",
          "package"        => "tightvnc",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "vnc",
          "server"         => Ops.add(@x_bin_path, "/vnc_inetd_httpd"),
          "server_args"    => "1024 768 5901",
          "service"        => "vnchttpd1",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= UNLISTED\n\tport\t\t= 5801\n",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: This serves out the vncviewer Java applet for the VNC \\\n" +
            "\tserver running on port 5902, (vnc port 2).\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "61:./etc/xinetd.d/vnc",
          "package"        => "tightvnc",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "vnc",
          "server"         => Ops.add(@x_bin_path, "/vnc_inetd_httpd"),
          "server_args"    => "1280 1024 5902",
          "service"        => "vnchttpd2",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= UNLISTED\n\tport\t\t= 5802\n",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description: This serves out the vncviewer Java applet for the VNC \\\n" +
            "\tserver running on port 5902, (vnc port 3).\n",
          "comment_inside" => "",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "76:./etc/xinetd.d/vnc",
          "package"        => "tightvnc",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "vnc",
          "server"         => Ops.add(@x_bin_path, "/vnc_inetd_httpd"),
          "server_args"    => "1600 1200 5903",
          "service"        => "vnchttpd3",
          "socket_type"    => "stream",
          "unparsed"       => "\ttype\t\t= UNLISTED\n\tport\t\t= 5803\n",
          "user"           => "nobody",
          "wait"           => false
        },
        {
          "comment"        => " default: off\n" +
            " description:\n" +
            "   The vsftpd FTP server serves FTP connections. It uses\n" +
            "   normal, unencrypted usernames and passwords for authentication.\n" +
            " vsftpd is designed to be secure.\n" +
            "\n" +
            " NOTE: This file contains the configuration for xinetd to start vsftpd.\n" +
            "       the configuration file for vsftp itself is in /etc/vsftpd.conf\n" +
            "\n",
          "comment_inside" => "        server_args             =\n" +
            "        log_on_success          += DURATION USERID\n" +
            "        log_on_failure          += USERID\n" +
            "        nice                    = 10\n",
          "enabled"        => false,
          "group"          => "",
          "iid"            => "1:./etc/xinetd.d/vsftpd",
          "package"        => "vsftpd",
          "protocol"       => "tcp",
          "rpc_version"    => "",
          "script"         => "vsftpd",
          "server"         => "/usr/sbin/vsftpd",
          "server_args"    => "",
          "service"        => "ftp",
          "socket_type"    => "stream",
          "unparsed"       => "",
          "user"           => "root",
          "wait"           => false
        }
      ]
    end

    def GetBinPath
      bin_path = XVersion.binPath
      if bin_path == nil
        Builtins.y2error("XVersion::binPath() is nil!")
        bin_path = ""
      end
      bin_path
    end
  end
end
